/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.custom;

import java.io.Serializable;
import java.util.List;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.Entity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntityManager;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JumpActivityCmd
implements Command,
Serializable {
    Logger logger = LoggerFactory.getLogger(JumpActivityCmd.class);
    private String activityId;
    private String taskId;
    private String jumpOrigin;
    private List<String> taskUsers;
    private String taskUser;

    public JumpActivityCmd(String taskId, String activityId, String jumpOrigin, List<String> taskUsers, String taskUser) {
        this(taskId, activityId, jumpOrigin);
        this.taskUsers = taskUsers;
        this.taskUser = taskUser;
    }

    public JumpActivityCmd(String taskId, String activityId) {
        this(taskId, activityId, "jump");
    }

    public JumpActivityCmd(String taskId, String activityId, String jumpOrigin) {
        this.activityId = activityId;
        this.taskId = taskId;
        this.jumpOrigin = jumpOrigin;
    }

    public Object execute(CommandContext commandContext) {
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        TaskEntity task = (TaskEntity)taskEntityManager.findById(this.taskId);
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(task.getExecutionId());
        execution.getCurrentFlowElement();
        String processDefinitionId = execution.getProcessDefinitionId();
        Process process = ProcessDefinitionUtil.getProcess((String)processDefinitionId);
        FlowElement targetFlowElement = process.getFlowElement(this.activityId, true);
        VariableInstanceEntityManager manager = commandContext.getVariableInstanceEntityManager();
        List taskOnCurrentExecution = taskEntityManager.findTasksByExecutionId(execution.getId());
        if (taskOnCurrentExecution != null) {
            for (TaskEntity taskEntity : taskOnCurrentExecution) {
            }
        }
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        executionEntityManager.deleteChildExecutions(execution.getParent(), this.jumpOrigin, true);
        taskEntityManager.deleteTask(task, this.jumpOrigin, false, true);
        ExecutionEntity nextExecution = (ExecutionEntity)commandContext.getExecutionEntityManager().create();
        nextExecution.setProcessDefinitionId(execution.getProcessDefinitionId());
        nextExecution.setProcessInstanceId(execution.getProcessInstanceId());
        nextExecution.setRootProcessInstanceId(execution.getRootProcessInstanceId());
        nextExecution.setTenantId(execution.getTenantId());
        nextExecution.setScope(false);
        nextExecution.setActive(true);
        nextExecution.setParentId(execution.getParentId() != null ? execution.getParentId() : execution.getId());
        nextExecution.setCurrentFlowElement(targetFlowElement);
        commandContext.getExecutionEntityManager().insert((Entity)nextExecution);
        commandContext.getAgenda().planContinueProcessInCompensation(nextExecution);
        return nextExecution;
    }
}

