/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.custom;

import com.hand.hap.activiti.components.ApprovalRule;
import com.hand.hap.activiti.core.IActivitiConstants;
import com.hand.hap.activiti.dto.ApproveChainHeader;
import com.hand.hap.activiti.dto.ApproveChainLine;
import com.hand.hap.activiti.service.IApproveChainHeaderService;
import com.hand.hap.activiti.service.IApproveChainLineService;
import com.hand.hap.activiti.util.ActivitiUtils;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.hr.dto.Employee;
import com.hand.hap.hr.service.IEmployeeService;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ForecastActivityCmd
implements Command,
Serializable,
IActivitiConstants {
    Logger logger = LoggerFactory.getLogger(ForecastActivityCmd.class);
    public static final ThreadLocal<UserTask> userTask = new ThreadLocal();
    public static final ThreadLocal<String> executionId = new ThreadLocal();
    public static final ThreadLocal<Integer> executedCount = new ThreadLocal();
    @Autowired
    private ApprovalRule approvalRule;
    @Autowired
    private IEmployeeService employeeService;
    @Autowired
    IApproveChainHeaderService approveChainHeaderService;
    @Autowired
    IApproveChainLineService approveChainLineService;

    public Object execute(CommandContext commandContext) {
        UserTask task = (UserTask)userTask.get();
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById((String)executionId.get());
        LinkedHashSet approve = new LinkedHashSet();
        boolean isAddApproveChain = ActivitiUtils.isAddApproveChain((UserTask)task);
        if (ActivitiUtils.isUseNewModelEditor((UserTask)task) && !isAddApproveChain) {
            Set apvCods = this.approvalRule.processCandidate(task, (DelegateExecution)execution);
            apvCods.forEach(t -> this.addEmp(approve, t));
        } else {
            if (isAddApproveChain) {
                ApproveChainHeader approveChainHeader = this.approveChainHeaderService.selectByUserTask(StringUtils.substringBefore((String)execution.getProcessDefinitionId(), (String)":"), task.getId());
                if (approveChainHeader == null) {
                    this.logger.debug("{} has no related approve chain", (Object)userTask);
                } else {
                    List chainLines = this.approveChainLineService.selectByHeaderId(RequestHelper.getCurrentRequest((boolean)true), approveChainHeader.getApproveChainId());
                    if (chainLines.isEmpty()) {
                        this.logger.warn("{} has no active approve chain line.", (Object)userTask);
                    }
                    int count = (Integer)executedCount.get();
                    int current = 0;
                    for (ApproveChainLine line : chainLines) {
                        if (current < count) {
                            ++current;
                            continue;
                        }
                        String assignee = line.getAssignee();
                        Object assObj = null;
                        if (StringUtils.isNotEmpty((String)assignee)) {
                            assObj = this.getValueFromExpression(expressionManager, execution, assignee);
                            if (assObj == null) continue;
                            this.addEmp(approve, assObj.toString());
                            continue;
                        }
                        String assigneeGrop = line.getAssignGroup();
                        if (!StringUtils.isNotEmpty((String)assigneeGrop)) continue;
                        assObj = this.getValueFromExpression(expressionManager, execution, assigneeGrop);
                        List emps = this.employeeService.selectByPostionCode(assObj.toString());
                        approve.addAll(emps);
                    }
                    return approve;
                }
            }
            String assignee = task.getAssignee();
            Object assObj = null;
            if (StringUtils.isNotEmpty((String)assignee)) {
                assObj = this.getValueFromExpression(expressionManager, execution, assignee);
                if (assObj != null) {
                    this.addEmp(approve, assObj.toString());
                }
            } else {
                if (task.getCandidateUsers() != null) {
                    task.getCandidateUsers().forEach(t -> {
                        Object value = this.getValueFromExpression(expressionManager, execution, t);
                        if (value != null) {
                            this.addEmp(approve, value.toString());
                        }
                    });
                }
                if (task.getCandidateGroups() != null) {
                    task.getCandidateGroups().forEach(t -> {
                        Object value = this.getValueFromExpression(expressionManager, execution, t);
                        List emps = this.employeeService.selectByPostionCode(value.toString());
                        approve.addAll(emps);
                    });
                }
            }
        }
        return approve;
    }

    private void addEmp(Set<Employee> approve, String employeeCode) {
        Employee emp = this.employeeService.queryInfoByCode(employeeCode);
        if (emp != null) {
            approve.add(emp);
        }
    }

    private Object getValueFromExpression(ExpressionManager expressionManager, ExecutionEntity execution, String exp) {
        Object value = null;
        try {
            value = expressionManager.createExpression(exp).getValue((VariableScope)execution);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return value;
    }
}

