/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.custom;

import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.BpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;

public class CustomSequentialMultiInstanceBehavior
extends SequentialMultiInstanceBehavior {
    public CustomSequentialMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        super(activity, innerActivityBehavior);
    }

    protected int createInstances(DelegateExecution multiInstanceExecution) {
        int nrOfInstances = this.resolveNrOfInstances(multiInstanceExecution);
        if (nrOfInstances == 0) {
            return nrOfInstances;
        }
        if (nrOfInstances < 0) {
            throw new ActivitiIllegalArgumentException("Invalid number of instances: must be a non-negative integer value, but was " + nrOfInstances);
        }
        ExecutionEntity execution = Context.getCommandContext().getExecutionEntityManager().createChildExecution((ExecutionEntity)multiInstanceExecution);
        execution.setCurrentFlowElement(multiInstanceExecution.getCurrentFlowElement());
        multiInstanceExecution.setMultiInstanceRoot(true);
        multiInstanceExecution.setActive(false);
        this.setLoopVariable(multiInstanceExecution, "nrOfInstances", (Object)nrOfInstances);
        this.setLoopVariable(multiInstanceExecution, "nrOfCompletedInstances", (Object)0);
        this.setLoopVariable(multiInstanceExecution, "nrOfActiveInstances", (Object)1);
        this.setLoopVariable(multiInstanceExecution, "nrOfApproved", (Object)0);
        this.setLoopVariable(multiInstanceExecution, "nrOfRejected", (Object)0);
        this.setLoopVariable(multiInstanceExecution, this.getCollectionElementIndexVariable(), (Object)0);
        this.setLoopVariable((DelegateExecution)execution, "nrOfInstances", (Object)nrOfInstances);
        this.setLoopVariable((DelegateExecution)execution, "nrOfCompletedInstances", (Object)0);
        this.setLoopVariable((DelegateExecution)execution, "nrOfActiveInstances", (Object)1);
        this.setLoopVariable((DelegateExecution)execution, "nrOfApproved", (Object)0);
        this.setLoopVariable((DelegateExecution)execution, "nrOfRejected", (Object)0);
        this.setLoopVariable((DelegateExecution)execution, this.getCollectionElementIndexVariable(), (Object)0);
        this.logLoopDetails(multiInstanceExecution, "initialized", 0, 0, 1, nrOfInstances);
        if (nrOfInstances > 0) {
            this.executeOriginalBehavior((DelegateExecution)execution, 0);
        }
        return nrOfInstances;
    }

    public void leave(DelegateExecution execution) {
        DelegateExecution multiInstanceRootExecution = this.getMultiInstanceRootExecution(execution);
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        int loopCounter = this.getLoopVariable(multiInstanceRootExecution, this.getCollectionElementIndexVariable()) + 1;
        int nrOfCompletedInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances");
        this.setLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances", (Object)nrOfCompletedInstances);
        String approveResult = String.valueOf(execution.getVariable("approveResult"));
        int nrOfApproved = this.getLoopVariable(multiInstanceRootExecution, "nrOfApproved");
        int nrOfRejected = this.getLoopVariable(multiInstanceRootExecution, "nrOfRejected");
        if ("APPROVED".equalsIgnoreCase(approveResult)) {
            this.setLoopVariable(multiInstanceRootExecution, "nrOfApproved", (Object)(++nrOfApproved));
        } else if ("REJECTED".equalsIgnoreCase(approveResult)) {
            this.setLoopVariable(multiInstanceRootExecution, "nrOfRejected", (Object)(++nrOfRejected));
        }
        this.setLoopVariable(multiInstanceRootExecution, this.getCollectionElementIndexVariable(), (Object)loopCounter);
        this.setLoopVariable(execution, this.getCollectionElementIndexVariable(), (Object)loopCounter);
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        Context.getCommandContext().getHistoryManager().recordActivityEnd((ExecutionEntity)execution, null);
        this.callActivityEndListeners(execution);
        if (loopCounter >= nrOfInstances || this.completionConditionSatisfied(multiInstanceRootExecution)) {
            this.removeLocalLoopVariable(multiInstanceRootExecution, this.getCollectionElementIndexVariable());
            this.removeLocalLoopVariable(execution, this.getCollectionElementIndexVariable());
            multiInstanceRootExecution.setMultiInstanceRoot(false);
            multiInstanceRootExecution.setScope(false);
            multiInstanceRootExecution.setCurrentFlowElement(execution.getCurrentFlowElement());
            Context.getCommandContext().getExecutionEntityManager().deleteChildExecutions((ExecutionEntity)multiInstanceRootExecution, "MI_END", false);
            new BpmnActivityBehavior().performDefaultOutgoingBehavior((ExecutionEntity)multiInstanceRootExecution);
        } else {
            try {
                if (execution.getCurrentFlowElement() instanceof SubProcess) {
                    ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
                    ExecutionEntity executionToContinue = executionEntityManager.createChildExecution((ExecutionEntity)multiInstanceRootExecution);
                    executionToContinue.setCurrentFlowElement(execution.getCurrentFlowElement());
                    executionToContinue.setScope(true);
                    this.setLoopVariable((DelegateExecution)executionToContinue, "nrOfInstances", (Object)nrOfInstances);
                    this.setLoopVariable((DelegateExecution)executionToContinue, "nrOfCompletedInstances", (Object)nrOfCompletedInstances);
                    this.setLoopVariable((DelegateExecution)executionToContinue, "nrOfActiveInstances", (Object)nrOfActiveInstances);
                    this.setLoopVariable((DelegateExecution)executionToContinue, "nrOfApproved", (Object)nrOfApproved);
                    this.setLoopVariable((DelegateExecution)executionToContinue, "nrOfRejected", (Object)nrOfRejected);
                    this.setLoopVariable((DelegateExecution)executionToContinue, this.getCollectionElementIndexVariable(), (Object)loopCounter);
                    this.executeOriginalBehavior((DelegateExecution)executionToContinue, loopCounter);
                } else {
                    this.executeOriginalBehavior(execution, loopCounter);
                }
            }
            catch (BpmnError error) {
                throw error;
            }
            catch (Exception e) {
                throw new ActivitiException("Could not execute inner activity behavior of multi instance behavior", (Throwable)e);
            }
        }
    }
}

