/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.controllers;

import com.hand.hap.activiti.components.ActivitiMultiLanguageManager;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.RequestHelper;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.repository.ProcessDefinitionCollectionResource;
import org.activiti.rest.service.api.repository.ProcessDefinitionResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wfl", "/api/wfl"})
public class ProcessDefinitionCollectionRestResource
extends ProcessDefinitionCollectionResource {
    @RequestMapping(value={"/repository/process-definitions"}, method={RequestMethod.GET}, produces={"application/json"})
    public DataResponse getProcessDefinitions(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        IRequest iRequest = RequestHelper.createServiceRequest((HttpServletRequest)request);
        if (ActivitiMultiLanguageManager.multiLanguageOpen && allRequestParams.containsKey("nameLike")) {
            allRequestParams.put("nameLike", ActivitiMultiLanguageManager.getMultiLanguageInfoByDescription((String)allRequestParams.get("nameLike"), (IRequest)iRequest));
        }
        DataResponse dataResponse = super.getProcessDefinitions(allRequestParams, request);
        if (ActivitiMultiLanguageManager.multiLanguageOpen && CollectionUtils.isNotEmpty((Collection)((List)dataResponse.getData()))) {
            List processDefinitionResponses = (List)dataResponse.getData();
            for (ProcessDefinitionResponse processDefinitionResponse : processDefinitionResponses) {
                processDefinitionResponse.setName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode((String)processDefinitionResponse.getName(), (IRequest)iRequest));
            }
        }
        return dataResponse;
    }
}

