/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hand.hap.activiti.components.ActivitiMultiLanguageManager;
import com.hand.hap.activiti.components.ApprovalRule;
import com.hand.hap.activiti.custom.process.CustomHistoricProcessInstanceQueryRequest;
import com.hand.hap.activiti.custom.task.CustomTaskQueryRequest;
import com.hand.hap.activiti.dto.ActivitiNode;
import com.hand.hap.activiti.dto.HistoricProcessInstanceResponseExt;
import com.hand.hap.activiti.dto.ProcessInstanceForecast;
import com.hand.hap.activiti.dto.TaskActionRequestExt;
import com.hand.hap.activiti.dto.TaskResponseExt;
import com.hand.hap.activiti.exception.TaskActionException;
import com.hand.hap.activiti.exception.WflSecurityException;
import com.hand.hap.activiti.exception.dto.ActiviException;
import com.hand.hap.activiti.service.IActivitiEntityService;
import com.hand.hap.activiti.service.IActivitiService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.converter.util.InputStreamProvider;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.util.io.InputStreamSource;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.image.ProcessDiagramGenerator;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.history.HistoricProcessInstanceQueryRequest;
import org.activiti.rest.service.api.history.HistoricTaskInstanceQueryRequest;
import org.activiti.rest.service.api.repository.ModelRequest;
import org.activiti.rest.service.api.repository.ModelResponse;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceCreateRequest;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceResponse;
import org.activiti.rest.service.api.runtime.task.TaskQueryRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/wfl", "/api/wfl"})
public class ActivitiController
extends BaseController {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RestResponseFactory restResponseFactory;
    @Autowired
    private IActivitiEntityService customEntityService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private IActivitiService activitiService;
    @Autowired
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ApprovalRule approvalRule;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/runtime/process-instances"}, method={RequestMethod.POST}, produces={"application/json"})
    public ProcessInstanceResponse createProcessInstance(@RequestBody ProcessInstanceCreateRequest request, HttpServletRequest httpRequest, HttpServletResponse response) {
        IRequest iRequest = this.createRequestContext(httpRequest);
        String employeeCode = httpRequest.getParameter("userId");
        if (StringUtils.isNotEmpty((String)employeeCode) && "ADMIN".equalsIgnoreCase(iRequest.getEmployeeCode())) {
            iRequest.setEmployeeCode(employeeCode);
        }
        return this.activitiService.startProcess(iRequest, request);
    }

    @RequestMapping(value={"/definition/user-tasks/{processInstanceId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ActivitiNode> getAvailableUserTask(HttpServletRequest request, @PathVariable String processInstanceId) {
        IRequest iRequest = this.createRequestContext(request);
        return this.activitiService.getProcessNodes(iRequest, processInstanceId);
    }

    @RequestMapping(value={"/query/tasks"}, method={RequestMethod.POST}, produces={"application/json"})
    public DataResponse getQueryResult(@RequestBody CustomTaskQueryRequest request, @RequestParam Map<String, String> requestParams, HttpServletRequest httpRequest) throws WflSecurityException {
        IRequest iRequest = this.createRequestContext(httpRequest);
        if (ActivitiMultiLanguageManager.multiLanguageOpen) {
            request.setProcessDefinitionName(ActivitiMultiLanguageManager.getMultiLanguageInfoByDescription((String)request.getProcessDefinitionNameLike(), (IRequest)iRequest));
            request.setProcessDefinitionNameLike(null);
        }
        if (StringUtils.isEmpty((String)iRequest.getEmployeeCode())) {
            throw new WflSecurityException("wfl.security.error.user_not_relate_emp");
        }
        request.setCandidateOrAssigned(iRequest.getEmployeeCode());
        DataResponse dataResponse = this.activitiService.queryTaskList(iRequest, (TaskQueryRequest)request, requestParams);
        return dataResponse;
    }

    @RequestMapping(value={"/query/tasks/admin"}, method={RequestMethod.POST}, produces={"application/json"})
    public DataResponse taskListAdmin(@RequestBody CustomTaskQueryRequest request, @RequestParam Map<String, String> requestParams, HttpServletRequest httpRequest) {
        IRequest iRequest = this.createRequestContext(httpRequest);
        if (ActivitiMultiLanguageManager.multiLanguageOpen) {
            request.setProcessDefinitionName(ActivitiMultiLanguageManager.getMultiLanguageInfoByDescription((String)request.getProcessDefinitionNameLike(), (IRequest)iRequest));
            request.setProcessDefinitionNameLike(null);
        }
        DataResponse dataResponse = this.activitiService.queryTaskList(iRequest, (TaskQueryRequest)request, requestParams);
        return dataResponse;
    }

    @RequestMapping(value={"/query/historic-task-instances"})
    public DataResponse queryProcessInstances(HistoricTaskInstanceQueryRequest queryRequest, @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        IRequest iRequest = this.createRequestContext(request);
        return this.activitiService.queryHistoricTaskInstances(iRequest, queryRequest, allRequestParams);
    }

    @RequestMapping(value={"/query/process-instances/my"})
    public DataResponse queryProcessInstances(@RequestBody CustomHistoricProcessInstanceQueryRequest historicProcessInstanceQueryRequest, @RequestParam Map<String, String> requestParams, HttpServletRequest httpRequest) throws WflSecurityException {
        IRequest iRequest = this.createRequestContext(httpRequest);
        if (ActivitiMultiLanguageManager.multiLanguageOpen) {
            historicProcessInstanceQueryRequest.setProcessDefinitionNameLike(ActivitiMultiLanguageManager.getMultiLanguageInfoByDescription((String)historicProcessInstanceQueryRequest.getProcessDefinitionNameLike(), (IRequest)iRequest));
        }
        if (StringUtils.isEmpty((String)iRequest.getEmployeeCode())) {
            throw new WflSecurityException("wfl.security.error.user_not_relate_emp");
        }
        if (Boolean.valueOf(requestParams.get("involved")).booleanValue()) {
            historicProcessInstanceQueryRequest.setInvolvedUser(iRequest.getEmployeeCode());
        } else if (Boolean.valueOf(requestParams.get("startedBy")).booleanValue()) {
            historicProcessInstanceQueryRequest.setStartedBy(iRequest.getEmployeeCode());
        } else if (Boolean.valueOf(requestParams.get("carbonCopy")).booleanValue()) {
            historicProcessInstanceQueryRequest.setCarbonCopyUser(iRequest.getEmployeeCode());
        } else {
            historicProcessInstanceQueryRequest.setInvolvedUser(iRequest.getEmployeeCode());
        }
        return this.activitiService.queryProcessInstances(iRequest, (HistoricProcessInstanceQueryRequest)historicProcessInstanceQueryRequest, requestParams, true);
    }

    @RequestMapping(value={"/activiti/process_history_carbon.html"})
    public ModelAndView carbonCopy(HttpServletRequest httpRequest) {
        ModelAndView mv = new ModelAndView(this.getViewPath() + "/activiti/process_history");
        mv.addObject("carbonCopy", (Object)true);
        return mv;
    }

    @RequestMapping(value={"/activiti/process_history_start.html"})
    public ModelAndView startedBy(HttpServletRequest httpRequest) {
        ModelAndView mv = new ModelAndView(this.getViewPath() + "/activiti/process_history");
        mv.addObject("startedBy", (Object)true);
        return mv;
    }

    @RequestMapping(value={"/query/process-instances/monitor"})
    public DataResponse queryAllProcessInstances(@RequestBody CustomHistoricProcessInstanceQueryRequest historicProcessInstanceQueryRequest, @RequestParam Map<String, String> requestParams, HttpServletRequest httpRequest) {
        IRequest iRequest = this.createRequestContext(httpRequest);
        if (ActivitiMultiLanguageManager.multiLanguageOpen) {
            historicProcessInstanceQueryRequest.setProcessDefinitionNameLike(ActivitiMultiLanguageManager.getMultiLanguageInfoByDescription((String)historicProcessInstanceQueryRequest.getProcessDefinitionNameLike(), (IRequest)iRequest));
        }
        return this.activitiService.queryProcessInstances(iRequest, (HistoricProcessInstanceQueryRequest)historicProcessInstanceQueryRequest, requestParams, false);
    }

    @RequestMapping(value={"/activiti/admin/task_detail.html"})
    public ModelAndView adminTask(HttpServletRequest httpRequest, String taskId) {
        ModelAndView mv = new ModelAndView(this.getViewPath() + "/activiti/task_detail");
        mv.addObject("taskId", (Object)taskId);
        mv.addObject("isAdmin", (Object)true);
        return mv;
    }

    @RequestMapping(value={"/runtime/tasks/{taskId}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void executeTaskAction(@PathVariable String taskId, @RequestBody TaskActionRequestExt actionRequest, HttpServletRequest request, HttpServletResponse response) throws TaskActionException {
        IRequest iRequest = this.createRequestContext(request);
        this.activitiService.executeTaskAction(iRequest, taskId, actionRequest, false);
    }

    @RequestMapping(value={"/runtime/admin/tasks/{taskId}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void executeTaskActionAdmin(@PathVariable String taskId, @RequestBody TaskActionRequestExt actionRequest, HttpServletRequest request, HttpServletResponse response) throws TaskActionException {
        IRequest iRequest = this.createRequestContext(request);
        this.activitiService.executeTaskAction(iRequest, taskId, actionRequest, true);
    }

    @RequestMapping(value={"/runtime/admin/tasks/batch-delegate"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void executeBatchDelegate(@RequestBody List<TaskActionRequestExt> actionRequests, HttpServletRequest request, HttpServletResponse response) throws TaskActionException {
        IRequest iRequest = this.createRequestContext(request);
        for (TaskActionRequestExt actionRequest : actionRequests) {
            actionRequest.setComment("");
            this.activitiService.executeTaskAction(iRequest, actionRequest.getCurrentTaskId(), actionRequest, true);
        }
    }

    @RequestMapping(value={"/repository/models"}, method={RequestMethod.POST}, produces={"application/json"})
    public ModelResponse createModel(@RequestBody ModelRequest modelRequest, HttpServletRequest request, HttpServletResponse response) {
        Model model = this.repositoryService.newModel();
        model.setCategory(modelRequest.getCategory());
        model.setDeploymentId(modelRequest.getDeploymentId());
        model.setKey(modelRequest.getKey());
        model.setMetaInfo(modelRequest.getMetaInfo());
        model.setName(modelRequest.getName());
        model.setVersion(modelRequest.getVersion());
        model.setTenantId(modelRequest.getTenantId());
        this.repositoryService.saveModel(model);
        response.setStatus(HttpStatus.CREATED.value());
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("resourceId", model.getId());
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("process_id", modelRequest.getKey());
        properties.put("name", modelRequest.getName());
        properties.put("process_namespace", modelRequest.getCategory());
        content.put("properties", properties);
        HashMap<String, String> stencilset = new HashMap<String, String>();
        stencilset.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
        content.put("stencilset", stencilset);
        try {
            this.repositoryService.addModelEditorSource(model.getId(), this.objectMapper.writeValueAsBytes(content));
        }
        catch (JsonProcessingException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return this.restResponseFactory.createModelResponse(model);
    }

    @RequestMapping(value={"/repository/model/node"})
    public ResponseData getUserTaskFromModelSource(HttpServletRequest request, String modelId) {
        IRequest iRequest = this.createRequestContext(request);
        List list = this.activitiService.getUserTaskFromModelSource(iRequest, modelId);
        return new ResponseData(list);
    }

    @RequestMapping(value={"/repository/model/{modelId}/deploy"})
    @ResponseBody
    public ResponseData modelDeployment(@PathVariable String modelId, HttpServletRequest request) {
        IRequest iRequest = this.createRequestContext(request);
        Model model = null;
        try {
            model = this.activitiService.deployModel(modelId);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            ResponseData rd = new ResponseData(false);
            rd.setMessage(e.getMessage());
            return rd;
        }
        model.setName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode((String)model.getName(), (IRequest)iRequest));
        return new ResponseData(Collections.singletonList(model));
    }

    @RequestMapping(value={"/repository/model/{modelId}/export"}, produces={"text/xml"})
    public ResponseEntity<byte[]> modelExport(@PathVariable String modelId, @RequestParam(defaultValue="") String type) throws IOException {
        Model model = this.repositoryService.getModel(modelId);
        byte[] modelData = this.repositoryService.getModelEditorSource(modelId);
        JsonNode jsonNode = this.objectMapper.readTree(modelData);
        BpmnModel bpmnModel = new BpmnJsonConverter().convertToBpmnModel(jsonNode);
        byte[] xmlBytes = new BpmnXMLConverter().convertToXML(bpmnModel, "UTF-8");
        HttpHeaders responseHeaders = new HttpHeaders();
        String id = model.getId();
        if (bpmnModel.getMainProcess() != null) {
            id = bpmnModel.getMainProcess().getId();
        }
        if ("bpmn20".equalsIgnoreCase(type)) {
            responseHeaders.set("Content-Disposition", "attachment;filename=" + id + ".bpmn20.xml");
            responseHeaders.set("Content-Type", "application/octet-stream");
        } else {
            responseHeaders.set("Content-Type", "text/xml;charset=utf8");
        }
        try {
            return new ResponseEntity((Object)xmlBytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            throw new ActivitiIllegalArgumentException("Error exporting diagram", (Throwable)e);
        }
    }

    @RequestMapping(value={"/repository/deploy/{deployId}/export"})
    public ResponseEntity<byte[]> deployExport(@PathVariable String deployId) throws IOException {
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(deployId);
        byte[] xmlBytes = new BpmnXMLConverter().convertToXML(bpmnModel, "UTF-8");
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Content-Type", "text/xml;charset=utf8");
        try {
            return new ResponseEntity((Object)xmlBytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            throw new ActivitiIllegalArgumentException("Error exporting diagram", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/repository/model/import"}, produces={"text/html;charset=UTF-8"})
    public String importModel(HttpServletRequest request) throws FileUploadException, IOException {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return "<script>alert('NOT a Multipart Request')</script>";
        }
        InputStream fileInputStream = null;
        String name = null;
        String key = null;
        String category = null;
        if (request instanceof MultipartHttpServletRequest) {
            MultipartFile file = ((MultipartHttpServletRequest)request).getFile("file");
            if (file != null) {
                fileInputStream = file.getInputStream();
            }
            name = request.getParameter("name");
            key = request.getParameter("key");
            category = request.getParameter("category");
        } else {
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
            List items = upload.parseRequest(request);
            FileItem item = null;
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (FileItem fi : items) {
                if (!fi.isFormField()) {
                    item = fi;
                    continue;
                }
                parameters.put(fi.getFieldName(), fi.getString("UTF-8"));
            }
            if (item != null && StringUtils.isNotEmpty((String)item.getName())) {
                fileInputStream = item.getInputStream();
                name = (String)parameters.get("name");
                key = (String)parameters.get("key");
                category = (String)parameters.get("category");
            }
        }
        if (fileInputStream == null) {
            return "<script>alert('File Content is Null')</script>";
        }
        try (InputStream inputStream = fileInputStream;){
            InputStreamSource source = new InputStreamSource(fileInputStream);
            BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel((InputStreamProvider)source, false, false, "UTF-8");
            bpmnModel.getMainProcess().setId(StringUtils.defaultIfEmpty((String)key, (String)bpmnModel.getMainProcess().getId()));
            bpmnModel.getMainProcess().setName(StringUtils.defaultIfEmpty((String)name, (String)bpmnModel.getMainProcess().getName()));
            Model model = this.repositoryService.newModel();
            model.setCategory(StringUtils.defaultIfEmpty((String)category, (String)"default"));
            model.setDeploymentId(null);
            model.setKey(bpmnModel.getMainProcess().getId());
            model.setName(bpmnModel.getMainProcess().getName());
            String metaInfo = model.getMetaInfo();
            if (StringUtils.isEmpty((String)metaInfo)) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", model.getName());
                map.put("version", String.valueOf(model.getVersion()));
                metaInfo = this.objectMapper.writeValueAsString(map);
            }
            model.setMetaInfo(metaInfo);
            this.repositoryService.saveModel(model);
            ObjectNode content = new BpmnJsonConverter().convertToJson(bpmnModel);
            content = this.approvalRule.processCustomProperties(content);
            this.repositoryService.addModelEditorSource(model.getId(), this.objectMapper.writeValueAsBytes((Object)content));
            this.restResponseFactory.createModelResponse(model);
            String string = "<script>window.parent.onImportComplete(true)</script>";
            return string;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return "<script>window.parent.onImportComplete(false,'\u8bf7\u4e0a\u4f20\u7b26\u5408 BPMN \u89c4\u8303\u7684\u6587\u4ef6')</script>";
        }
    }

    @RequestMapping(value={"/runtime/tasks/{taskId}/details"})
    @ResponseBody
    public TaskResponseExt taskDetails(HttpServletRequest request, @PathVariable String taskId) throws WflSecurityException {
        IRequest iRequest = this.createRequestContext(request);
        return this.activitiService.getTaskDetails(iRequest, taskId);
    }

    @RequestMapping(value={"/runtime/admin/tasks/{taskId}/details"})
    @ResponseBody
    public TaskResponseExt taskDetailsAdmin(HttpServletRequest request, @PathVariable String taskId) throws WflSecurityException {
        IRequest iRequest = this.createRequestContext(request);
        return this.activitiService.getTaskDetails(iRequest, taskId, true);
    }

    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/forecast"})
    public List<ProcessInstanceForecast> getProcessInstanceForecast(HttpServletRequest request, @PathVariable String processInstanceId) {
        IRequest iRequest = this.createRequestContext(request);
        return this.activitiService.processInstanceForecast(iRequest, processInstanceId);
    }

    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/diagram"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> getProcessInstanceDiagram(@PathVariable String processInstanceId, HttpServletRequest request, HttpServletResponse response) {
        IRequest iRequest = this.createRequestContext(request);
        boolean isActivity = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult() != null;
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).list().iterator().next();
        ProcessDefinition pde = this.repositoryService.getProcessDefinition(processInstance.getProcessDefinitionId());
        if (pde != null && pde.hasGraphicalNotation()) {
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(pde.getId());
            ProcessDiagramGenerator diagramGenerator = this.processEngineConfiguration.getProcessDiagramGenerator();
            List finished = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).finished().list();
            HashMap boundaryUserTask = new HashMap();
            HashMap nodeEndTime = new HashMap();
            List ids = finished.stream().map(e -> {
                if (StringUtils.isNotEmpty((String)e.getDeleteReason()) && e.getDeleteReason().contains("boundary")) {
                    boundaryUserTask.put(e.getActivityId(), true);
                }
                nodeEndTime.put(e.getActivityId(), e.getEndTime());
                return e.getActivityId() + "__his__";
            }).collect(Collectors.toList());
            if (isActivity) {
                ids.addAll(this.runtimeService.getActiveActivityIds(processInstance.getId()));
            }
            ArrayList<String> flows = new ArrayList<String>();
            List flowElement = bpmnModel.getMainProcess().findFlowElementsOfType(SequenceFlow.class);
            HashedMap idMap = new HashedMap();
            for (Object id : ids) {
                if (((String)id).endsWith("__his__")) {
                    id = ((String)id).substring(0, ((String)id).indexOf("__his__"));
                }
                idMap.put(id, true);
            }
            HashMap<String, Date> exclusiveGatewayEarliestEndNode = new HashMap<String, Date>();
            for (SequenceFlow flowElement1 : flowElement) {
                boolean boundary;
                Date currentNodeEndTime;
                FlowNode node;
                List flowList;
                String startId = flowElement1.getSourceRef();
                String endId = flowElement1.getTargetRef();
                Boolean isStartId = (Boolean)idMap.get(startId);
                Boolean isEndId = (Boolean)idMap.get(endId);
                Boolean isSelectFlow = Boolean.TRUE;
                if (flowElement1.getSourceFlowElement() instanceof ExclusiveGateway && CollectionUtils.isNotEmpty((Collection)(flowList = (node = (FlowNode)flowElement1.getSourceFlowElement()).getOutgoingFlows())) && flowList.size() > 1 && (currentNodeEndTime = (Date)nodeEndTime.get(endId)) != null) {
                    if (exclusiveGatewayEarliestEndNode.containsKey(node.getId())) {
                        Date currentEarliestNodeEndTime = (Date)exclusiveGatewayEarliestEndNode.get(node.getId());
                        if (!currentNodeEndTime.equals(currentEarliestNodeEndTime)) {
                            isSelectFlow = Boolean.FALSE;
                        }
                    } else {
                        Date earliestNodeEndTime = (Date)nodeEndTime.get(((SequenceFlow)flowList.get(0)).getTargetRef());
                        for (int i = 1; i < flowList.size(); ++i) {
                            Date flowNodeEndTime = (Date)nodeEndTime.get(((SequenceFlow)flowList.get(i)).getTargetRef());
                            if (flowNodeEndTime == null || earliestNodeEndTime != null && !flowNodeEndTime.before(earliestNodeEndTime)) continue;
                            earliestNodeEndTime = flowNodeEndTime;
                        }
                        exclusiveGatewayEarliestEndNode.put(node.getId(), earliestNodeEndTime);
                        if (!currentNodeEndTime.equals(earliestNodeEndTime)) {
                            isSelectFlow = Boolean.FALSE;
                        }
                    }
                }
                boolean bl = boundary = boundaryUserTask.get(startId) != null ? (Boolean)boundaryUserTask.get(startId) : false;
                if (!BooleanUtils.isTrue((Boolean)isStartId) || boundary || !BooleanUtils.isTrue((Boolean)isEndId) || !isSelectFlow.booleanValue()) continue;
                flows.add(flowElement1.getId());
            }
            HashMap<String, String> oldFlowNodeName = new HashMap<String, String>();
            List flowNodes = bpmnModel.getMainProcess().findFlowElementsOfType(FlowNode.class);
            for (Object flowNode : flowNodes) {
                oldFlowNodeName.put(flowNode.getId(), flowNode.getName());
                flowNode.setName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode((String)flowNode.getName(), (IRequest)iRequest));
            }
            InputStream resource = diagramGenerator.generateDiagram(bpmnModel, "svg", ids, flows, this.processEngineConfiguration.getActivityFontName(), this.processEngineConfiguration.getLabelFontName(), this.processEngineConfiguration.getAnnotationFontName(), this.processEngineConfiguration.getClassLoader(), 1.0);
            for (FlowNode flowNode : flowNodes) {
                flowNode.setName((String)oldFlowNodeName.get(flowNode.getId()));
            }
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.set("Content-Type", "image/svg+xml");
            try {
                return new ResponseEntity((Object)IOUtils.toByteArray((InputStream)resource), (MultiValueMap)responseHeaders, HttpStatus.OK);
            }
            catch (Exception e2) {
                throw new ActivitiIllegalArgumentException("Error exporting diagram", (Throwable)e2);
            }
        }
        throw new ActivitiIllegalArgumentException("Process instance with id '" + processInstance.getId() + "' has no graphical notation defined.");
    }

    @RequestMapping(value={"/history/form/details/{procId}"})
    @ResponseBody
    public ResponseData getFromVar(HttpServletRequest request, @PathVariable String procId) {
        List list = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(procId).list();
        return new ResponseData(list);
    }

    @RequestMapping(value={"/instance/{processInstanceId}"})
    @ResponseBody
    public HistoricProcessInstanceResponseExt instanceDetail(HttpServletRequest request, @PathVariable String processInstanceId) throws WflSecurityException {
        IRequest iRequest = this.createRequestContext(request);
        return this.activitiService.getInstanceDetail(iRequest, processInstanceId);
    }

    @RequestMapping(value={"/instance/carbon-copy-read"})
    @ResponseBody
    public void carbonCopyRead(HttpServletRequest request, @RequestBody HistoricProcessInstanceResponseExt processInstanceResponseExt) throws WflSecurityException {
        IRequest iRequest = this.createRequestContext(request);
        if ("N".equalsIgnoreCase(processInstanceResponseExt.getReadFlag())) {
            this.activitiService.processCarbonCopyRead(processInstanceResponseExt.getId(), iRequest.getEmployeeCode());
        }
    }

    @RequestMapping(value={"/runtime/prc/suspend/{procId}"})
    public void suspendProc(HttpServletRequest request, @PathVariable String procId) {
        this.runtimeService.suspendProcessInstanceById(procId);
    }

    @RequestMapping(value={"/runtime/prc/active/{procId}"})
    public void activeProc(HttpServletRequest request, @PathVariable String procId) {
        this.runtimeService.activateProcessInstanceById(procId);
    }

    @RequestMapping(value={"/runtime/prc/end/{procId}"}, method={RequestMethod.POST})
    @ResponseBody
    public void endProc(HttpServletRequest request, @PathVariable String procId) {
        this.activitiService.deleteProcessInstance(procId);
    }

    @RequestMapping(value={"/runtime/prc/back/{procId}"}, method={RequestMethod.POST})
    @ResponseBody
    public void backProc(HttpServletRequest request, @PathVariable String procId) {
        IRequest iRequest = this.createRequestContext(request);
        if (this.activitiService.isStartRecall(procId, iRequest.getEmployeeCode()).booleanValue()) {
            this.activitiService.startRecall(iRequest, procId, iRequest.getEmployeeCode());
        } else if (this.activitiService.isTaskRecall(procId, iRequest.getEmployeeCode()).booleanValue()) {
            this.activitiService.taskRecall(iRequest, procId, iRequest.getEmployeeCode());
        }
    }

    @RequestMapping(value={"/runtime/exception/search"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData searchException(HttpServletRequest request, ActiviException exception, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest iRequest = this.createRequestContext(request);
        List exceptions = this.activitiService.queryException(exception, page, pagesize);
        if (ActivitiMultiLanguageManager.multiLanguageOpen && CollectionUtils.isNotEmpty((Collection)exceptions)) {
            for (ActiviException exception1 : exceptions) {
                exception1.setProcDefName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode((String)exception1.getProcDefName(), (IRequest)iRequest));
            }
        }
        return new ResponseData(exceptions);
    }

    @RequestMapping(value={"/runtime/execute/{procId}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseData executeTaskActionByAdmin(@PathVariable String procId, @RequestBody TaskActionRequestExt actionRequest, HttpServletRequest request, HttpServletResponse response) throws TaskActionException {
        actionRequest.setComment("");
        IRequest iRequest = this.createRequestContext(request);
        this.activitiService.executeTaskByAdmin(iRequest, procId, actionRequest);
        return new ResponseData();
    }

    @RequestMapping(value={"/repository/deployments/{deploymentId}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public void deleteDeployment(@PathVariable String deploymentId, @RequestParam(value="cascade", required=false, defaultValue="false") Boolean cascade, HttpServletResponse response) {
        this.activitiService.deleteDeployment(deploymentId, cascade);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

