/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.components;

import com.hand.hap.activiti.custom.ICustomTaskProcessor;
import com.hand.hap.activiti.util.ActivitiUtils;
import java.util.Date;
import org.activiti.engine.task.Task;
import org.springframework.stereotype.Component;

@Component
public class DefaultCustomTaskProcessor
implements ICustomTaskProcessor {
    public Task processPriority(Task task) {
        Long dueTime = ActivitiUtils.secondsBetweenDate((Date)task.getCreateTime(), (Date)task.getDueDate());
        Long interval = this.getDueTime(task.getCreateTime(), dueTime);
        int priority = task.getPriority();
        if (interval <= 0L) {
            task.setPriority(100);
        } else if (interval <= dueTime / 3L) {
            task.setPriority(90);
        } else if (interval <= dueTime / 3L * 2L) {
            if (priority < 33) {
                task.setPriority(50);
            } else {
                task.setPriority(80);
            }
        }
        return task;
    }

    public Long getDueTime(Date startDate, Long dueTime) {
        Long elapsedTime = ActivitiUtils.secondsBetweenDate((Date)startDate, (Date)new Date());
        Long processDueTime = dueTime - elapsedTime;
        return processDueTime;
    }

    public boolean processorContinue() {
        return true;
    }

    public int getOrder() {
        return 999;
    }
}

