/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.approval.service.impl;

import com.hand.hap.activiti.approval.dto.BusinessRuleHeader;
import com.hand.hap.activiti.approval.dto.BusinessRuleLine;
import com.hand.hap.activiti.approval.mapper.BusinessRuleHeaderMapper;
import com.hand.hap.activiti.approval.mapper.BusinessRuleLineMapper;
import com.hand.hap.activiti.approval.service.IBusinessRuleHeaderService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class BusinessRuleHeaderServiceImpl
extends BaseServiceImpl<BusinessRuleHeader>
implements IBusinessRuleHeaderService {
    @Autowired
    private BusinessRuleHeaderMapper headerMapper;
    @Autowired
    private BusinessRuleLineMapper lineMapper;

    private void processLines(BusinessRuleHeader header) {
        for (BusinessRuleLine line : header.getLines()) {
            if (line.getBusinessRuleId() == null) {
                line.setBusinessRuleId(header.getBusinessRuleId());
                this.lineMapper.insertSelective((Object)line);
                continue;
            }
            if (line.getBusinessRuleId() == null) continue;
            int updateCount = this.lineMapper.updateByPrimaryKeySelective((Object)line);
            this.checkOvn(updateCount, (Object)header);
        }
    }

    public List<BusinessRuleHeader> batchUpdate(IRequest request, List<BusinessRuleHeader> headers) {
        for (BusinessRuleHeader header : headers) {
            if (header.getBusinessRuleId() == null) {
                ((IBusinessRuleHeaderService)this.self()).createRule(header);
                continue;
            }
            if (header.getBusinessRuleId() == null) continue;
            ((IBusinessRuleHeaderService)this.self()).updateRule(header);
        }
        return headers;
    }

    public boolean batchDelete(IRequest request, List<BusinessRuleHeader> headers) {
        BusinessRuleLine line = new BusinessRuleLine();
        for (BusinessRuleHeader header : headers) {
            line.setBusinessRuleId(header.getBusinessRuleId());
            int count = this.lineMapper.delete((Object)line);
            this.checkOvn(count, (Object)line);
            int updateCount = this.headerMapper.deleteByPrimaryKey((Object)header);
            this.checkOvn(updateCount, (Object)header);
        }
        return true;
    }

    public List<BusinessRuleHeader> selectAll(IRequest request, BusinessRuleHeader header) {
        return this.headerMapper.select((Object)header);
    }

    public BusinessRuleHeader createRule(BusinessRuleHeader header) {
        this.headerMapper.insertSelective((Object)header);
        if (header.getLines() != null) {
            this.processLines(header);
        }
        return null;
    }

    public BusinessRuleHeader updateRule(BusinessRuleHeader header) {
        int count = this.headerMapper.updateByPrimaryKey((Object)header);
        this.checkOvn(count, (Object)header);
        if (header.getLines() != null) {
            this.processLines(header);
        }
        return header;
    }
}

