/*
 * Decompiled with CFR 0.152.
 */
package com.faw.common.goddog.spring.rest;

import com.faw.common.goddog.spring.HttpHeadersCarrier;
import com.faw.common.goddog.spring.rest.GoddogRestTemplateSpanInterceptor;
import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class GoddogRestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    private static final Log log = LogFactory.getLog(GoddogRestTemplateInterceptor.class);
    private Tracer tracer;
    private List<GoddogRestTemplateSpanInterceptor> spanInterceptors;

    public GoddogRestTemplateInterceptor(Tracer tracer, List<GoddogRestTemplateSpanInterceptor> spanInterceptors) {
        this.tracer = tracer;
        this.spanInterceptors = new ArrayList<GoddogRestTemplateSpanInterceptor>(spanInterceptors);
    }

    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse httpResponse;
        try (Scope scope = this.tracer.buildSpan(httpRequest.getMethod().toString()).withTag(Tags.SPAN_KIND.getKey(), "client").startActive(true);){
            this.tracer.inject(scope.span().context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersCarrier(httpRequest.getHeaders()));
            for (GoddogRestTemplateSpanInterceptor goddogRestTemplateSpanInterceptor : this.spanInterceptors) {
                try {
                    goddogRestTemplateSpanInterceptor.onRequest(httpRequest, scope.span());
                }
                catch (RuntimeException exInterceptor) {
                    log.error((Object)"Exception during decorating span", (Throwable)exInterceptor);
                }
            }
            try {
                httpResponse = execution.execute(httpRequest, body);
            }
            catch (Exception ex) {
                for (GoddogRestTemplateSpanInterceptor spanInterceptor : this.spanInterceptors) {
                    try {
                        spanInterceptor.onError(httpRequest, ex, scope.span());
                    }
                    catch (RuntimeException exInterceptor) {
                        log.error((Object)"Exception during decorating span", (Throwable)exInterceptor);
                    }
                }
                throw ex;
            }
            for (GoddogRestTemplateSpanInterceptor goddogRestTemplateSpanInterceptor : this.spanInterceptors) {
                try {
                    goddogRestTemplateSpanInterceptor.onResponse(httpRequest, httpResponse, scope.span());
                }
                catch (RuntimeException exInterceptor) {
                    log.error((Object)"Exception during decorating span", (Throwable)exInterceptor);
                }
            }
        }
        return httpResponse;
    }
}

