/*
 * Decompiled with CFR 0.152.
 */
package com.faw.common.goddog.spring.rest;

import com.faw.common.goddog.spring.HttpHeadersCarrier;
import com.faw.common.goddog.spring.rest.GoddogRestTemplateSpanInterceptor;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestExecution;
import org.springframework.http.client.AsyncClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class GoddogAsyncRestTemplateInterceptor
implements AsyncClientHttpRequestInterceptor {
    private static final Log log = LogFactory.getLog(GoddogAsyncRestTemplateInterceptor.class);
    private Tracer tracer;
    private List<GoddogRestTemplateSpanInterceptor> spanInterceptors;

    public GoddogAsyncRestTemplateInterceptor(Tracer tracer, List<GoddogRestTemplateSpanInterceptor> spanDecorators) {
        this.tracer = tracer;
        this.spanInterceptors = new ArrayList<GoddogRestTemplateSpanInterceptor>(spanDecorators);
    }

    public ListenableFuture<ClientHttpResponse> intercept(final HttpRequest httpRequest, byte[] body, AsyncClientHttpRequestExecution execution) throws IOException {
        final Scope scope = this.tracer.buildSpan(httpRequest.getMethod().toString()).withTag(Tags.SPAN_KIND.getKey(), "client").startActive(false);
        this.tracer.inject(scope.span().context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersCarrier(httpRequest.getHeaders()));
        for (GoddogRestTemplateSpanInterceptor spanIntercetor : this.spanInterceptors) {
            try {
                spanIntercetor.onRequest(httpRequest, scope.span());
            }
            catch (RuntimeException exDecorator) {
                log.error((Object)"Exception during decorating span", (Throwable)exDecorator);
            }
        }
        ListenableFuture future = execution.executeAsync(httpRequest, body);
        final Span span = scope.span();
        future.addCallback((ListenableFutureCallback)new ListenableFutureCallback<ClientHttpResponse>(){

            public void onSuccess(ClientHttpResponse httpResponse) {
                try (Scope asyncScope = GoddogAsyncRestTemplateInterceptor.this.tracer.scopeManager().activate(span, true);){
                    for (GoddogRestTemplateSpanInterceptor spanInterceptor : GoddogAsyncRestTemplateInterceptor.this.spanInterceptors) {
                        try {
                            spanInterceptor.onResponse(httpRequest, httpResponse, scope.span());
                        }
                        catch (RuntimeException exDecorator) {
                            log.error((Object)"Exception during decorating span", (Throwable)exDecorator);
                        }
                    }
                }
            }

            public void onFailure(Throwable t) {
                try (Scope asyncScope = GoddogAsyncRestTemplateInterceptor.this.tracer.scopeManager().activate(span, true);){
                    for (GoddogRestTemplateSpanInterceptor spanInterceptor : GoddogAsyncRestTemplateInterceptor.this.spanInterceptors) {
                        try {
                            spanInterceptor.onError(httpRequest, t, scope.span());
                        }
                        catch (RuntimeException e) {
                            log.error((Object)"Exception during decorating span", (Throwable)e);
                        }
                    }
                }
            }
        });
        scope.close();
        return future;
    }
}

