/*
 * Decompiled with CFR 0.152.
 */
package com.faw.common.goddog.spring.interceptor;

import com.faw.common.goddog.spring.interceptor.GoddogHandlerInterceptor;
import com.faw.common.goddog.spring.interceptor.GoddogServletFilter;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class GoddogTracingHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final String SCOPE_STACK = GoddogTracingHandlerInterceptor.class.getName() + ".scopeStack";
    private static final String CONTINUATION_FROM_ASYNC_STARTED = GoddogTracingHandlerInterceptor.class.getName() + ".continuation";
    private Tracer tracer;
    private List<GoddogHandlerInterceptor> interceptors;

    public GoddogTracingHandlerInterceptor(Tracer tracer, List<GoddogHandlerInterceptor> interceptors) {
        this.tracer = tracer;
        this.interceptors = interceptors;
    }

    static boolean isTraced(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getAttribute(GoddogServletFilter.SERVER_SPAN_CONTEXT) instanceof SpanContext;
    }

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object handler) throws Exception {
        if (!GoddogTracingHandlerInterceptor.isTraced(httpServletRequest)) {
            return true;
        }
        Scope serverSpan = this.tracer.scopeManager().active();
        if (serverSpan == null) {
            if (httpServletRequest.getAttribute(CONTINUATION_FROM_ASYNC_STARTED) != null) {
                Span contd = (Span)httpServletRequest.getAttribute(CONTINUATION_FROM_ASYNC_STARTED);
                serverSpan = this.tracer.scopeManager().activate(contd, false);
                httpServletRequest.removeAttribute(CONTINUATION_FROM_ASYNC_STARTED);
            } else {
                serverSpan = this.tracer.buildSpan(httpServletRequest.getMethod()).addReference("follows_from", GoddogServletFilter.serverSpanContext((ServletRequest)httpServletRequest)).startActive(true);
            }
            Deque<Scope> activeSpanStack = this.getScopeStack(httpServletRequest);
            activeSpanStack.push(serverSpan);
        }
        for (GoddogHandlerInterceptor decorator : this.interceptors) {
            decorator.onPreHandle(httpServletRequest, handler, serverSpan.span());
        }
        return true;
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object handler) throws Exception {
        Span span;
        if (!GoddogTracingHandlerInterceptor.isTraced(httpServletRequest)) {
            return;
        }
        Deque<Scope> activeSpanStack = this.getScopeStack(httpServletRequest);
        if (activeSpanStack.size() > 0) {
            Scope scope = activeSpanStack.pop();
            span = scope.span();
            this.onAfterConcurrentHandlingStarted(httpServletRequest, httpServletResponse, handler, span);
            scope.close();
        } else {
            span = this.tracer.activeSpan();
            this.onAfterConcurrentHandlingStarted(httpServletRequest, httpServletResponse, handler, span);
        }
        httpServletRequest.setAttribute(CONTINUATION_FROM_ASYNC_STARTED, (Object)span);
    }

    private void onAfterConcurrentHandlingStarted(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object handler, Span span) {
        for (GoddogHandlerInterceptor decorator : this.interceptors) {
            decorator.onAfterConcurrentHandlingStarted(httpServletRequest, httpServletResponse, handler, span);
        }
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object handler, Exception ex) throws Exception {
        if (!GoddogTracingHandlerInterceptor.isTraced(httpServletRequest)) {
            return;
        }
        Deque<Scope> scopeStack = this.getScopeStack(httpServletRequest);
        if (scopeStack.size() > 0) {
            Scope scope = scopeStack.pop();
            this.onAfterCompletion(httpServletRequest, httpServletResponse, handler, ex, scope.span());
            scope.close();
        } else {
            this.onAfterCompletion(httpServletRequest, httpServletResponse, handler, ex, this.tracer.activeSpan());
        }
    }

    private void onAfterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object handler, Exception ex, Span span) {
        for (GoddogHandlerInterceptor decorator : this.interceptors) {
            decorator.onAfterCompletion(httpServletRequest, httpServletResponse, handler, ex, span);
        }
    }

    private Deque<Scope> getScopeStack(HttpServletRequest request) {
        ArrayDeque stack = (ArrayDeque)request.getAttribute(SCOPE_STACK);
        if (stack == null) {
            stack = new ArrayDeque();
            request.setAttribute(SCOPE_STACK, stack);
        }
        return stack;
    }
}

