/*
 * Decompiled with CFR 0.152.
 */
package com.faw.common.goddog.spring.interceptor;

import com.faw.common.goddog.spring.interceptor.HttpServletRequestExtractAdapter;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GoddogServletFilter
implements Filter {
    private static final Logger log = Logger.getLogger(GoddogServletFilter.class.getName());
    public static final String SPAN_DECORATORS = GoddogServletFilter.class.getName() + ".spanDecorators";
    public static final String SKIP_PATTERN = GoddogServletFilter.class.getName() + ".skipPattern";
    public static final String SERVER_SPAN_CONTEXT = GoddogServletFilter.class.getName() + ".activeSpanContext";
    private Tracer tracer;
    private List<ServletFilterSpanDecorator> spanDecorators;
    private Pattern skipPattern;

    public GoddogServletFilter(Tracer tracer, List<ServletFilterSpanDecorator> spanDecorators, Pattern skipPattern) {
        this.tracer = tracer;
        this.spanDecorators = spanDecorators;
        this.skipPattern = skipPattern;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        Object tracerObj = servletContext.getAttribute(Tracer.class.getName());
        if (tracerObj instanceof Tracer) {
            this.tracer = (Tracer)tracerObj;
        } else {
            servletContext.setAttribute(Tracer.class.getName(), (Object)this.tracer);
        }
        Object contextAttribute = servletContext.getAttribute(SPAN_DECORATORS);
        if (contextAttribute instanceof Collection) {
            ArrayList<ServletFilterSpanDecorator> decorators = new ArrayList<ServletFilterSpanDecorator>();
            for (Object decorator : (Collection)contextAttribute) {
                if (decorator instanceof ServletFilterSpanDecorator) {
                    decorators.add((ServletFilterSpanDecorator)decorator);
                    continue;
                }
                log.severe(decorator + " is not an instance of " + ServletFilterSpanDecorator.class);
            }
            List<ServletFilterSpanDecorator> list = this.spanDecorators = decorators.size() > 0 ? decorators : this.spanDecorators;
        }
        if ((contextAttribute = servletContext.getAttribute(SKIP_PATTERN)) instanceof Pattern) {
            this.skipPattern = (Pattern)contextAttribute;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        Scope scope;
        HttpServletRequest httpRequest;
        block13: {
            httpRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
            if (!this.isTraced(httpRequest, httpResponse)) {
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return;
            }
            if (servletRequest.getAttribute(SERVER_SPAN_CONTEXT) != null) {
                chain.doFilter(servletRequest, servletResponse);
                return;
            }
            SpanContext extractedContext = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new HttpServletRequestExtractAdapter(httpRequest));
            scope = this.tracer.buildSpan(httpRequest.getMethod()).asChildOf(extractedContext).withTag(Tags.SPAN_KIND.getKey(), "server").startActive(false);
            httpRequest.setAttribute(SERVER_SPAN_CONTEXT, (Object)scope.span().context());
            for (ServletFilterSpanDecorator spanDecorator : this.spanDecorators) {
                spanDecorator.onRequest(httpRequest, scope.span());
            }
            try {
                chain.doFilter(servletRequest, servletResponse);
                if (httpRequest.isAsyncStarted()) break block13;
                for (ServletFilterSpanDecorator spanDecorator : this.spanDecorators) {
                    spanDecorator.onResponse(httpRequest, httpResponse, scope.span());
                }
            }
            catch (Throwable ex) {
                try {
                    for (ServletFilterSpanDecorator spanDecorator : this.spanDecorators) {
                        spanDecorator.onError(httpRequest, httpResponse, ex, scope.span());
                    }
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (httpRequest.isAsyncStarted()) {
                        httpRequest.getAsyncContext().addListener(new AsyncListener(scope){
                            final /* synthetic */ Scope val$scope;
                            {
                                this.val$scope = scope;
                            }

                            public void onComplete(AsyncEvent event) throws IOException {
                                HttpServletRequest httpRequest = (HttpServletRequest)event.getSuppliedRequest();
                                HttpServletResponse httpResponse = (HttpServletResponse)event.getSuppliedResponse();
                                for (ServletFilterSpanDecorator spanDecorator : GoddogServletFilter.this.spanDecorators) {
                                    spanDecorator.onResponse(httpRequest, httpResponse, this.val$scope.span());
                                }
                                this.val$scope.span().finish();
                            }

                            public void onTimeout(AsyncEvent event) throws IOException {
                                HttpServletRequest httpRequest = (HttpServletRequest)event.getSuppliedRequest();
                                HttpServletResponse httpResponse = (HttpServletResponse)event.getSuppliedResponse();
                                for (ServletFilterSpanDecorator spanDecorator : GoddogServletFilter.this.spanDecorators) {
                                    spanDecorator.onTimeout(httpRequest, httpResponse, event.getAsyncContext().getTimeout(), this.val$scope.span());
                                }
                            }

                            public void onError(AsyncEvent event) throws IOException {
                                HttpServletRequest httpRequest = (HttpServletRequest)event.getSuppliedRequest();
                                HttpServletResponse httpResponse = (HttpServletResponse)event.getSuppliedResponse();
                                for (ServletFilterSpanDecorator spanDecorator : GoddogServletFilter.this.spanDecorators) {
                                    spanDecorator.onError(httpRequest, httpResponse, event.getThrowable(), this.val$scope.span());
                                }
                            }

                            public void onStartAsync(AsyncEvent event) throws IOException {
                            }
                        });
                    } else {
                        scope.span().finish();
                    }
                    scope.close();
                    throw throwable;
                }
            }
        }
        if (httpRequest.isAsyncStarted()) {
            httpRequest.getAsyncContext().addListener(new /* invalid duplicate definition of identical inner class */);
        } else {
            scope.span().finish();
        }
        scope.close();
        return;
    }

    protected boolean isTraced(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this.skipPattern != null) {
            String url = httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
            return !this.skipPattern.matcher(url).matches();
        }
        return true;
    }

    public void destroy() {
    }

    public static SpanContext serverSpanContext(ServletRequest servletRequest) {
        return (SpanContext)servletRequest.getAttribute(SERVER_SPAN_CONTEXT);
    }

    public static interface ServletFilterSpanDecorator {
        public static final ServletFilterSpanDecorator STANDARD_TAGS = new ServletFilterSpanDecorator(){

            @Override
            public void onRequest(HttpServletRequest httpServletRequest, Span span) {
                Tags.COMPONENT.set(span, "java-web-servlet");
                Tags.HTTP_METHOD.set(span, httpServletRequest.getMethod());
                Tags.HTTP_URL.set(span, httpServletRequest.getRequestURL().toString());
            }

            @Override
            public void onResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Span span) {
                Tags.HTTP_STATUS.set(span, Integer.valueOf(httpServletResponse.getStatus()));
            }

            @Override
            public void onError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Throwable exception, Span span) {
                Tags.ERROR.set(span, Boolean.TRUE);
                span.log(this.logsForException(exception));
                if (httpServletResponse.getStatus() == 200) {
                    Tags.HTTP_STATUS.set(span, Integer.valueOf(500));
                }
            }

            @Override
            public void onTimeout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long timeout, Span span) {
                HashMap<String, Object> timeoutLogs = new HashMap<String, Object>(2);
                timeoutLogs.put("event", "timeout");
                timeoutLogs.put("timeout", timeout);
                span.log(timeoutLogs);
            }

            private Map<String, String> logsForException(Throwable throwable) {
                String message;
                HashMap<String, String> errorLog = new HashMap<String, String>(3);
                errorLog.put("event", Tags.ERROR.getKey());
                String string = message = throwable.getCause() != null ? throwable.getCause().getMessage() : throwable.getMessage();
                if (message != null) {
                    errorLog.put("message", message);
                }
                StringWriter sw = new StringWriter();
                throwable.printStackTrace(new PrintWriter(sw));
                errorLog.put("stack", sw.toString());
                return errorLog;
            }
        };

        public void onRequest(HttpServletRequest var1, Span var2);

        public void onResponse(HttpServletRequest var1, HttpServletResponse var2, Span var3);

        public void onError(HttpServletRequest var1, HttpServletResponse var2, Throwable var3, Span var4);

        public void onTimeout(HttpServletRequest var1, HttpServletResponse var2, long var3, Span var5);
    }
}

