/*
 * Decompiled with CFR 0.152.
 */
package com.faw.common.goddog.plugins.sofa;

import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import com.faw.common.goddog.core.GoddogTracer;
import com.faw.common.goddog.plugins.sofa.GoddogSofaServerSpanDecorator;
import com.faw.common.goddog.plugins.sofa.SofaRequestCarrierAdapter;
import com.faw.common.goddog.plugins.sofa.SpringUtil;
import io.opentracing.Scope;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;

@AutoActive(providerSide=true)
@Extension(value="goddogServerSofaFilter")
public class GoddogServerSofaFilter
extends Filter {
    private Tracer tracer;
    private GoddogSofaServerSpanDecorator spanDecorator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public SofaResponse invoke(FilterInvoker invoker, SofaRequest request) throws SofaRpcException {
        Class<GoddogServerSofaFilter> clazz;
        if (this.tracer == null) {
            clazz = GoddogServerSofaFilter.class;
            // MONITORENTER : com.faw.common.goddog.plugins.sofa.GoddogServerSofaFilter.class
            if (this.tracer == null) {
                this.tracer = (Tracer)SpringUtil.getBean(GoddogTracer.class);
            }
            // MONITOREXIT : clazz
        }
        if (this.spanDecorator == null) {
            clazz = GoddogServerSofaFilter.class;
            // MONITORENTER : com.faw.common.goddog.plugins.sofa.GoddogServerSofaFilter.class
            if (this.spanDecorator == null) {
                this.spanDecorator = SpringUtil.getBean(GoddogSofaServerSpanDecorator.class);
            }
            // MONITOREXIT : clazz
        }
        SpanContext extractedContext = this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)new SofaRequestCarrierAdapter(request));
        this.spanDecorator.onRequest(request, scope.span());
        try (Scope scope = this.tracer.buildSpan(request.getMethod().toString()).asChildOf(extractedContext).withTag(Tags.SPAN_KIND.getKey(), "client").startActive(false);){
            SofaResponse response = invoker.invoke(request);
            this.spanDecorator.onResponse(request, response, scope.span());
            SofaResponse sofaResponse = response;
            return sofaResponse;
        }
    }
}

