/*
 * Decompiled with CFR 0.152.
 */
package com.faw.common.goddog.plugins.sofa;

import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import com.faw.common.goddog.core.GoddogTracer;
import com.faw.common.goddog.plugins.sofa.GoddogSofaClientSpanDecorator;
import com.faw.common.goddog.plugins.sofa.SofaPropsCarrier;
import com.faw.common.goddog.plugins.sofa.SpringUtil;
import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;

@AutoActive(consumerSide=true)
@Extension(value="goddogClientSofaFilter")
public class GoddogClientSofaFilter
extends Filter {
    private Tracer tracer;
    private GoddogSofaClientSpanDecorator spanDecorator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public SofaResponse invoke(FilterInvoker invoker, SofaRequest request) throws SofaRpcException {
        Class<GoddogClientSofaFilter> clazz;
        if (this.tracer == null) {
            clazz = GoddogClientSofaFilter.class;
            // MONITORENTER : com.faw.common.goddog.plugins.sofa.GoddogClientSofaFilter.class
            if (this.tracer == null) {
                this.tracer = (Tracer)SpringUtil.getBean(GoddogTracer.class);
            }
            // MONITOREXIT : clazz
        }
        if (this.spanDecorator == null) {
            clazz = GoddogClientSofaFilter.class;
            // MONITORENTER : com.faw.common.goddog.plugins.sofa.GoddogClientSofaFilter.class
            if (this.spanDecorator == null) {
                this.spanDecorator = SpringUtil.getBean(GoddogSofaClientSpanDecorator.class);
            }
            // MONITOREXIT : clazz
        }
        Scope scope = this.tracer.buildSpan(request.getMethod().toString()).withTag(Tags.SPAN_KIND.getKey(), "client").startActive(true);
        this.tracer.inject(scope.span().context(), Format.Builtin.TEXT_MAP, (Object)new SofaPropsCarrier(request));
        this.spanDecorator.onRequest(request, scope.span());
        try {
            SofaResponse response = invoker.invoke(request);
            this.spanDecorator.onResponse(request, response, scope.span());
            SofaResponse sofaResponse = response;
            return sofaResponse;
        }
        catch (Throwable ex) {
            this.spanDecorator.onError(request, ex, scope.span());
            throw ex;
        }
        finally {
            scope.close();
        }
    }
}

