/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;

public class SqlIntervalYearMonth {
    private final long months;

    public SqlIntervalYearMonth(long months) {
        this.months = months;
    }

    public SqlIntervalYearMonth(int year, int months) {
        this.months = 12 * year + months;
    }

    public int hashCode() {
        return Objects.hash(this.months);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlIntervalYearMonth other = (SqlIntervalYearMonth)obj;
        return Objects.equals(this.months, other.months);
    }

    @JsonValue
    public String toString() {
        return SqlIntervalYearMonth.formatMonths(this.months);
    }

    public static String formatMonths(long months) {
        return months / 12L + "-" + months % 12L;
    }
}

