/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractVariableWidthBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.VariableWidthBlock;
import com.facebook.presto.spi.type.TypeManager;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class VariableWidthBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<VariableWidthBlockEncoding> FACTORY = new VariableWidthBlockEncodingFactory();
    private static final String NAME = "VARIABLE_WIDTH";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        int position;
        AbstractVariableWidthBlock variableWidthBlock = (AbstractVariableWidthBlock)block;
        int positionCount = variableWidthBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        int totalLength = 0;
        for (position = 0; position < positionCount; ++position) {
            int length = variableWidthBlock.getLength(position);
            sliceOutput.appendInt(length);
            totalLength += length;
        }
        for (position = 0; position < (positionCount & 0xFFFFFFF8); position += 8) {
            int value = 0;
            value = (byte)(value | (variableWidthBlock.isNull(position) ? 128 : 0));
            value = (byte)(value | (variableWidthBlock.isNull(position + 1) ? 64 : 0));
            value = (byte)(value | (variableWidthBlock.isNull(position + 2) ? 32 : 0));
            value = (byte)(value | (variableWidthBlock.isNull(position + 3) ? 16 : 0));
            value = (byte)(value | (variableWidthBlock.isNull(position + 4) ? 8 : 0));
            value = (byte)(value | (variableWidthBlock.isNull(position + 5) ? 4 : 0));
            value = (byte)(value | (variableWidthBlock.isNull(position + 6) ? 2 : 0));
            value = (byte)(value | (variableWidthBlock.isNull(position + 7) ? 1 : 0));
            sliceOutput.appendByte(value);
        }
        if ((positionCount & 7) > 0) {
            int value = 0;
            int mask = 128;
            for (int position2 = positionCount & 0xFFFFFFF8; position2 < positionCount; ++position2) {
                value = (byte)(value | (variableWidthBlock.isNull(position2) ? mask : 0));
                mask >>>= 1;
            }
            sliceOutput.appendByte(value);
        }
        sliceOutput.appendInt(totalLength).writeBytes(variableWidthBlock.getRawSlice(), variableWidthBlock.getPositionOffset(0), totalLength);
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        int[] offsets = new int[positionCount + 1];
        int offset = 0;
        for (int position = 0; position < positionCount; ++position) {
            offsets[position + 1] = offset += sliceInput.readInt();
        }
        boolean[] valueIsNull = new boolean[positionCount];
        for (int position = 0; position < (positionCount & 0xFFFFFFF8); position += 8) {
            byte value = sliceInput.readByte();
            valueIsNull[position] = (value & 0x80) != 0;
            valueIsNull[position + 1] = (value & 0x40) != 0;
            valueIsNull[position + 2] = (value & 0x20) != 0;
            valueIsNull[position + 3] = (value & 0x10) != 0;
            valueIsNull[position + 4] = (value & 8) != 0;
            valueIsNull[position + 5] = (value & 4) != 0;
            valueIsNull[position + 6] = (value & 2) != 0;
            valueIsNull[position + 7] = (value & 1) != 0;
        }
        if ((positionCount & 7) > 0) {
            byte value = sliceInput.readByte();
            int mask = 128;
            for (int position = positionCount & 0xFFFFFFF8; position < positionCount; ++position) {
                valueIsNull[position] = (value & mask) != 0;
                mask >>>= 1;
            }
        }
        int blockSize = sliceInput.readInt();
        Slice slice = sliceInput.readSlice(blockSize);
        return new VariableWidthBlock(positionCount, slice, offsets, valueIsNull);
    }

    public static class VariableWidthBlockEncodingFactory
    implements BlockEncodingFactory<VariableWidthBlockEncoding> {
        @Override
        public String getName() {
            return VariableWidthBlockEncoding.NAME;
        }

        @Override
        public VariableWidthBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            return new VariableWidthBlockEncoding();
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, VariableWidthBlockEncoding blockEncoding) {
        }
    }
}

