/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.Objects;

public class EquiJoinClause {
    private final VariableReferenceExpression left;
    private final VariableReferenceExpression right;

    @JsonCreator
    public EquiJoinClause(@JsonProperty(value="left") VariableReferenceExpression left, @JsonProperty(value="right") VariableReferenceExpression right) {
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
    }

    @JsonProperty
    public VariableReferenceExpression getLeft() {
        return this.left;
    }

    @JsonProperty
    public VariableReferenceExpression getRight() {
        return this.right;
    }

    public EquiJoinClause flip() {
        return new EquiJoinClause(this.right, this.left);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        EquiJoinClause other = (EquiJoinClause)obj;
        return Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public String toString() {
        return String.format("%s = %s", this.left, this.right);
    }
}

