/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class CteReferenceNode
extends PlanNode {
    private final PlanNode source;
    private final String cteName;

    @JsonCreator
    public CteReferenceNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="cteName") String cteName) {
        this(sourceLocation, id, Optional.empty(), source, cteName);
    }

    public CteReferenceNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source, String cteName) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.cteName = Objects.requireNonNull(cteName, "cteName must not be null");
        this.source = Objects.requireNonNull(source, "source must not be null");
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.singletonList(this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.source.getOutputVariables();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Objects.requireNonNull(newChildren, "newChildren is null");
        CteReferenceNode.checkArgument(newChildren.size() == 1, "expected newChildren to contain 1 node");
        return new CteReferenceNode(newChildren.get(0).getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.get(0), this.cteName);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new CteReferenceNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.cteName);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitCteReference(this, context);
    }

    public String getCteName() {
        return this.cteName;
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }
}

