/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class CteConsumerNode
extends PlanNode {
    private final String cteName;
    private final List<VariableReferenceExpression> originalOutputVariables;
    private final PlanNode originalSource;

    @JsonCreator
    public CteConsumerNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="outputvars") List<VariableReferenceExpression> originalOutputVariables, @JsonProperty(value="cteName") String cteName, @JsonProperty(value="originalSource") PlanNode originalSource) {
        this(sourceLocation, id, Optional.empty(), originalOutputVariables, cteName, originalSource);
    }

    public CteConsumerNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, List<VariableReferenceExpression> originalOutputVariables, String cteName, PlanNode originalSource) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.cteName = Objects.requireNonNull(cteName, "cteName must not be null");
        this.originalOutputVariables = Objects.requireNonNull(originalOutputVariables, "originalOutputVariables must not be null");
        this.originalSource = originalSource;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.emptyList();
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.originalOutputVariables;
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        CteConsumerNode.checkArgument(newChildren.size() == 0, "expected newChildren to contain 0 node");
        return new CteConsumerNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), this.originalOutputVariables, this.cteName, this.originalSource);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new CteConsumerNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.originalOutputVariables, this.cteName, this.originalSource);
    }

    public PlanNode getOriginalSource() {
        return this.originalSource;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitCteConsumer(this, context);
    }

    @JsonProperty
    public String getCteName() {
        return this.cteName;
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }
}

