/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.analyzer;

import com.facebook.presto.jdbc.internal.common.WarningHandlingLevel;
import com.facebook.presto.jdbc.internal.spi.WarningCollector;
import java.util.Objects;

public class AnalyzerOptions {
    private final boolean isParseDecimalLiteralsAsDouble;
    private final boolean isLogFormattedQueryEnabled;
    private final WarningHandlingLevel warningHandlingLevel;
    private final WarningCollector warningCollector;

    private AnalyzerOptions(boolean isParseDecimalLiteralsAsDouble, boolean isLogFormattedQueryEnabled, WarningCollector warningCollector, WarningHandlingLevel warningHandlingLevel) {
        this.isParseDecimalLiteralsAsDouble = isParseDecimalLiteralsAsDouble;
        this.isLogFormattedQueryEnabled = isLogFormattedQueryEnabled;
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.warningHandlingLevel = Objects.requireNonNull(warningHandlingLevel, "warningHandlingLevel is null");
    }

    public boolean isParseDecimalLiteralsAsDouble() {
        return this.isParseDecimalLiteralsAsDouble;
    }

    public boolean isLogFormattedQueryEnabled() {
        return this.isLogFormattedQueryEnabled;
    }

    public WarningCollector getWarningCollector() {
        return this.warningCollector;
    }

    public WarningHandlingLevel getWarningHandlingLevel() {
        return this.warningHandlingLevel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean isParseDecimalLiteralsAsDouble;
        private boolean isLogFormattedQueryEnabled;
        private WarningCollector warningCollector = WarningCollector.NOOP;
        private WarningHandlingLevel warningHandlingLevel = WarningHandlingLevel.NORMAL;

        private Builder() {
        }

        public Builder setParseDecimalLiteralsAsDouble(boolean parseDecimalLiteralsAsDouble) {
            this.isParseDecimalLiteralsAsDouble = parseDecimalLiteralsAsDouble;
            return this;
        }

        public Builder setLogFormattedQueryEnabled(boolean logFormattedQueryEnabled) {
            this.isLogFormattedQueryEnabled = logFormattedQueryEnabled;
            return this;
        }

        public Builder setWarningCollector(WarningCollector warningCollector) {
            this.warningCollector = warningCollector;
            return this;
        }

        public Builder setWarningHandlingLevel(WarningHandlingLevel warningHandlingLevel) {
            this.warningHandlingLevel = warningHandlingLevel;
            return this;
        }

        public AnalyzerOptions build() {
            return new AnalyzerOptions(this.isParseDecimalLiteralsAsDouble, this.isLogFormattedQueryEnabled, this.warningCollector, this.warningHandlingLevel);
        }
    }
}

