/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.analyzer;

import com.facebook.presto.jdbc.internal.common.QualifiedObjectName;
import com.facebook.presto.jdbc.internal.common.transaction.TransactionId;
import com.facebook.presto.jdbc.internal.spi.analyzer.AccessControlInfo;
import com.facebook.presto.jdbc.internal.spi.security.AccessControl;
import com.facebook.presto.jdbc.internal.spi.security.AccessControlContext;
import com.facebook.presto.jdbc.internal.spi.security.Identity;
import java.util.Objects;
import java.util.Optional;

public class AccessControlInfoForTable {
    private final AccessControlInfo accessControlInfo;
    private final QualifiedObjectName tableName;

    public AccessControlInfoForTable(AccessControl accessControl, Identity identity, Optional<TransactionId> transactionId, AccessControlContext accessControlContext, QualifiedObjectName tableName) {
        this(new AccessControlInfo(accessControl, identity, transactionId, accessControlContext), tableName);
    }

    public AccessControlInfoForTable(AccessControlInfo accessControlInfo, QualifiedObjectName tableName) {
        this.accessControlInfo = Objects.requireNonNull(accessControlInfo, "accessControlInfo is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    public AccessControlInfo getAccessControlInfo() {
        return this.accessControlInfo;
    }

    public QualifiedObjectName getTableName() {
        return this.tableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessControlInfoForTable that = (AccessControlInfoForTable)o;
        return Objects.equals(this.accessControlInfo, that.accessControlInfo) && Objects.equals(this.tableName, that.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.accessControlInfo, this.tableName);
    }

    public String toString() {
        return "AccessControlInfoForTable{accessControlInfo=" + this.accessControlInfo + ", tableName=" + this.tableName + '}';
    }
}

