/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser;

import com.facebook.presto.jdbc.internal.guava.collect.ImmutableMap;
import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.core.JsonProcessingException;
import com.facebook.presto.jdbc.internal.jackson.core.JsonToken;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.JavaType;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.KeyDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.deser.NullValueProvider;
import com.facebook.presto.jdbc.internal.jackson.databind.jsontype.TypeDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.GuavaMapDeserializer;
import java.io.IOException;

abstract class GuavaImmutableMapDeserializer<T extends ImmutableMap<Object, Object>>
extends GuavaMapDeserializer<T> {
    private static final long serialVersionUID = 2L;

    GuavaImmutableMapDeserializer(JavaType type, KeyDeserializer keyDeser, JsonDeserializer<?> valueDeser, TypeDeserializer valueTypeDeser, NullValueProvider nuller) {
        super(type, keyDeser, valueDeser, valueTypeDeser, nuller);
    }

    protected abstract ImmutableMap.Builder<Object, Object> createBuilder();

    @Override
    protected T _deserializeEntries(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        KeyDeserializer keyDes = this._keyDeserializer;
        JsonDeserializer valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        ImmutableMap.Builder<Object, Object> builder = this.createBuilder();
        while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
            Object value;
            String fieldName = p.getCurrentName();
            String key = keyDes == null ? fieldName : keyDes.deserializeKey(fieldName, ctxt);
            JsonToken t = p.nextToken();
            if (t == JsonToken.VALUE_NULL) {
                if (!this._skipNullValues && (value = this._nullProvider.getNullValue(ctxt)) != null) {
                    builder.put(key, value);
                }
            } else {
                value = typeDeser == null ? valueDes.deserialize(p, ctxt) : valueDes.deserializeWithType(p, ctxt, typeDeser);
                builder.put(key, value);
            }
            p.nextToken();
        }
        ImmutableMap<Object, Object> map = builder.build();
        return (T)map;
    }
}

