/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.predicate;

import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.predicate.Range;
import com.facebook.presto.jdbc.internal.common.predicate.ValueSet;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Domain {
    private final ValueSet values;
    private final boolean nullAllowed;

    private Domain(ValueSet values, boolean nullAllowed) {
        this.values = Objects.requireNonNull(values, "values is null");
        this.nullAllowed = nullAllowed;
    }

    @JsonCreator
    public static Domain create(@JsonProperty(value="values") ValueSet values, @JsonProperty(value="nullAllowed") boolean nullAllowed) {
        return new Domain(values, nullAllowed);
    }

    public static Domain none(Type type) {
        return new Domain(ValueSet.none(type), false);
    }

    public static Domain all(Type type) {
        return new Domain(ValueSet.all(type), true);
    }

    public static Domain onlyNull(Type type) {
        return new Domain(ValueSet.none(type), true);
    }

    public static Domain notNull(Type type) {
        return new Domain(ValueSet.all(type), false);
    }

    public static Domain singleValue(Type type, Object value) {
        return new Domain(ValueSet.of(type, value, new Object[0]), false);
    }

    public static Domain multipleValues(Type type, List<?> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("values cannot be empty");
        }
        if (values.size() == 1) {
            return Domain.singleValue(type, values.get(0));
        }
        return new Domain(ValueSet.of(type, values.get(0), values.subList(1, values.size()).toArray()), false);
    }

    public Type getType() {
        return this.values.getType();
    }

    @JsonProperty
    public ValueSet getValues() {
        return this.values;
    }

    @JsonProperty
    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    public boolean isNone() {
        return this.values.isNone() && !this.nullAllowed;
    }

    public boolean isAll() {
        return this.values.isAll() && this.nullAllowed;
    }

    public boolean isSingleValue() {
        return !this.nullAllowed && this.values.isSingleValue();
    }

    public boolean isNullableSingleValue() {
        if (this.nullAllowed) {
            return this.values.isNone();
        }
        return this.values.isSingleValue();
    }

    public boolean isOnlyNull() {
        return this.values.isNone() && this.nullAllowed;
    }

    public Object getSingleValue() {
        if (!this.isSingleValue()) {
            throw new IllegalStateException("Domain is not a single value");
        }
        return this.values.getSingleValue();
    }

    public Object getNullableSingleValue() {
        if (!this.isNullableSingleValue()) {
            throw new IllegalStateException("Domain is not a nullable single value");
        }
        if (this.nullAllowed) {
            return null;
        }
        return this.values.getSingleValue();
    }

    public boolean includesNullableValue(Object value) {
        return value == null ? this.nullAllowed : this.values.containsValue(value);
    }

    public boolean overlaps(Domain other) {
        this.checkCompatibility(other);
        return !this.intersect(other).isNone();
    }

    public boolean contains(Domain other) {
        this.checkCompatibility(other);
        return this.union(other).equals(this);
    }

    public Domain intersect(Domain other) {
        this.checkCompatibility(other);
        return new Domain(this.values.intersect(other.getValues()), this.isNullAllowed() && other.isNullAllowed());
    }

    public Domain union(Domain other) {
        this.checkCompatibility(other);
        return new Domain(this.values.union(other.getValues()), this.isNullAllowed() || other.isNullAllowed());
    }

    public static Domain union(List<Domain> domains) {
        if (domains.isEmpty()) {
            throw new IllegalArgumentException("domains cannot be empty for union");
        }
        if (domains.size() == 1) {
            return domains.get(0);
        }
        boolean nullAllowed = false;
        ArrayList<ValueSet> valueSets = new ArrayList<ValueSet>(domains.size());
        for (Domain domain : domains) {
            valueSets.add(domain.getValues());
            nullAllowed = nullAllowed || domain.nullAllowed;
        }
        ValueSet unionedValues = ((ValueSet)valueSets.get(0)).union(valueSets.subList(1, valueSets.size()));
        return new Domain(unionedValues, nullAllowed);
    }

    public Domain complement() {
        return new Domain(this.values.complement(), !this.nullAllowed);
    }

    public Domain subtract(Domain other) {
        this.checkCompatibility(other);
        return new Domain(this.values.subtract(other.getValues()), this.isNullAllowed() && !other.isNullAllowed());
    }

    private void checkCompatibility(Domain domain) {
        if (!this.getType().equals(domain.getType())) {
            throw new IllegalArgumentException(String.format("Mismatched Domain types: %s vs %s", this.getType(), domain.getType()));
        }
        if (this.values.getClass() != domain.values.getClass()) {
            throw new IllegalArgumentException(String.format("Mismatched Domain value set classes: %s vs %s", this.values.getClass(), domain.values.getClass()));
        }
    }

    public int hashCode() {
        return Objects.hash(this.values, this.nullAllowed);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Domain other = (Domain)obj;
        return Objects.equals(this.values, other.values) && this.nullAllowed == other.nullAllowed;
    }

    public Domain simplify() {
        ValueSet simplifiedValueSet = this.values.getValuesProcessor().transform(ranges -> {
            if (ranges.getOrderedRanges().size() <= 32) {
                return Optional.empty();
            }
            return Optional.of(ValueSet.ofRanges(ranges.getSpan(), new Range[0]));
        }, discreteValues -> {
            if (discreteValues.getValues().size() <= 32) {
                return Optional.empty();
            }
            return Optional.of(ValueSet.all(this.values.getType()));
        }, allOrNone -> Optional.empty()).orElse(this.values);
        return Domain.create(simplifiedValueSet, this.nullAllowed);
    }

    public Domain canonicalize(boolean removeConstants) {
        return new Domain(this.values.canonicalize(removeConstants), this.nullAllowed);
    }

    public String toString(SqlFunctionProperties properties) {
        return "[ " + (this.nullAllowed ? "NULL, " : "") + this.values.toString(properties) + " ]";
    }
}

