/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.client;

import com.facebook.presto.jdbc.internal.client.NodeVersion;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftConstructor;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftField;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftStruct;
import com.facebook.presto.jdbc.internal.guava.base.MoreObjects;
import com.facebook.presto.jdbc.internal.io.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import java.util.Objects;
import java.util.Optional;

@ThriftStruct
@Immutable
public class ServerInfo {
    private final NodeVersion nodeVersion;
    private final String environment;
    private final boolean coordinator;
    private final boolean starting;
    private final Optional<Duration> uptime;

    @ThriftConstructor
    @JsonCreator
    public ServerInfo(@JsonProperty(value="nodeVersion") NodeVersion nodeVersion, @JsonProperty(value="environment") String environment, @JsonProperty(value="coordinator") boolean coordinator, @JsonProperty(value="starting") boolean starting, @JsonProperty(value="uptime") Optional<Duration> uptime) {
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.coordinator = coordinator;
        this.starting = starting;
        this.uptime = Objects.requireNonNull(uptime, "uptime is null");
    }

    @ThriftField(value=1)
    @JsonProperty
    public NodeVersion getNodeVersion() {
        return this.nodeVersion;
    }

    @ThriftField(value=2)
    @JsonProperty
    public String getEnvironment() {
        return this.environment;
    }

    @ThriftField(value=3)
    @JsonProperty
    public boolean isCoordinator() {
        return this.coordinator;
    }

    @ThriftField(value=4)
    @JsonProperty
    public boolean isStarting() {
        return this.starting;
    }

    @ThriftField(value=5)
    @JsonProperty
    public Optional<Duration> getUptime() {
        return this.uptime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerInfo that = (ServerInfo)o;
        return Objects.equals(this.nodeVersion, that.nodeVersion) && Objects.equals(this.environment, that.environment);
    }

    public int hashCode() {
        return Objects.hash(this.nodeVersion, this.environment);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("nodeVersion", this.nodeVersion).add("environment", this.environment).add("coordinator", this.coordinator).add("uptime", this.uptime.orElse(null)).omitNullValues().toString();
    }
}

