/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.connector.classloader;

import com.facebook.presto.jdbc.internal.spi.ConnectorInsertTableHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorOutputTableHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorPageSink;
import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.PageSinkProperties;
import com.facebook.presto.jdbc.internal.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.jdbc.internal.spi.connector.classloader.ClassLoaderSafeConnectorPageSink;
import java.util.Objects;

public final class ClassLoaderSafeConnectorPageSinkProvider
implements ConnectorPageSinkProvider {
    private final ConnectorPageSinkProvider delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorPageSinkProvider(ConnectorPageSinkProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, PageSinkProperties pageSinkProperties) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeConnectorPageSink classLoaderSafeConnectorPageSink = new ClassLoaderSafeConnectorPageSink(this.delegate.createPageSink(transactionHandle, session, outputTableHandle, pageSinkProperties), this.classLoader);
            return classLoaderSafeConnectorPageSink;
        }
    }

    @Override
    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, PageSinkProperties pageSinkProperties) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeConnectorPageSink classLoaderSafeConnectorPageSink = new ClassLoaderSafeConnectorPageSink(this.delegate.createPageSink(transactionHandle, session, insertTableHandle, pageSinkProperties), this.classLoader);
            return classLoaderSafeConnectorPageSink;
        }
    }
}

