/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.joda.ser;

import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializationFeature;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg.FormatConfig;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.ser.JodaDateSerializerBase;
import com.facebook.presto.jdbc.internal.joda.time.MonthDay;
import java.io.IOException;

public class MonthDaySerializer
extends JodaDateSerializerBase<MonthDay> {
    private static final long serialVersionUID = 1L;

    public MonthDaySerializer() {
        this(FormatConfig.DEFAULT_MONTH_DAY_FORMAT, 0);
    }

    public MonthDaySerializer(JacksonJodaDateFormat format) {
        this(format, 0);
    }

    public MonthDaySerializer(JacksonJodaDateFormat format, int shapeOverride) {
        super(MonthDay.class, format, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, 1, shapeOverride);
    }

    public MonthDaySerializer withFormat(JacksonJodaDateFormat formatter, int shapeOverride) {
        return new MonthDaySerializer(formatter, shapeOverride);
    }

    @Override
    public void serialize(MonthDay value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(this._format.createFormatter(provider).print(value));
    }
}

