/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.type.NamedTypeSignature;
import com.facebook.presto.jdbc.internal.common.type.ParameterKind;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import java.util.Objects;
import java.util.Optional;

public class TypeSignatureParameter {
    private final ParameterKind kind;
    private final Object value;

    public static TypeSignatureParameter of(TypeSignature typeSignature) {
        return new TypeSignatureParameter(ParameterKind.TYPE, typeSignature);
    }

    public static TypeSignatureParameter of(long longLiteral) {
        return new TypeSignatureParameter(ParameterKind.LONG, longLiteral);
    }

    public static TypeSignatureParameter of(NamedTypeSignature namedTypeSignature) {
        return new TypeSignatureParameter(ParameterKind.NAMED_TYPE, namedTypeSignature);
    }

    public static TypeSignatureParameter of(String variable) {
        return new TypeSignatureParameter(ParameterKind.VARIABLE, variable);
    }

    private TypeSignatureParameter(ParameterKind kind, Object value) {
        this.kind = Objects.requireNonNull(kind, "kind is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public String toString() {
        return this.value.toString();
    }

    public ParameterKind getKind() {
        return this.kind;
    }

    public boolean isTypeSignature() {
        return this.kind == ParameterKind.TYPE;
    }

    public boolean isLongLiteral() {
        return this.kind == ParameterKind.LONG;
    }

    public boolean isNamedTypeSignature() {
        return this.kind == ParameterKind.NAMED_TYPE;
    }

    public boolean isVariable() {
        return this.kind == ParameterKind.VARIABLE;
    }

    private <A> A getValue(ParameterKind expectedParameterKind, Class<A> target) {
        if (this.kind != expectedParameterKind) {
            throw new IllegalArgumentException(String.format("ParameterKind is [%s] but expected [%s]", new Object[]{this.kind, expectedParameterKind}));
        }
        return target.cast(this.value);
    }

    public TypeSignature getTypeSignature() {
        return this.getValue(ParameterKind.TYPE, TypeSignature.class);
    }

    public Long getLongLiteral() {
        return this.getValue(ParameterKind.LONG, Long.class);
    }

    public NamedTypeSignature getNamedTypeSignature() {
        return this.getValue(ParameterKind.NAMED_TYPE, NamedTypeSignature.class);
    }

    public String getVariable() {
        return this.getValue(ParameterKind.VARIABLE, String.class);
    }

    public Optional<TypeSignature> getTypeSignatureOrNamedTypeSignature() {
        switch (this.kind) {
            case TYPE: {
                return Optional.of(this.getTypeSignature());
            }
            case NAMED_TYPE: {
                return Optional.of(this.getNamedTypeSignature().getTypeSignature());
            }
        }
        return Optional.empty();
    }

    public boolean isCalculated() {
        switch (this.kind) {
            case TYPE: {
                return this.getTypeSignature().isCalculated();
            }
            case NAMED_TYPE: {
                return this.getNamedTypeSignature().getTypeSignature().isCalculated();
            }
            case LONG: {
                return false;
            }
            case VARIABLE: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected parameter kind: " + (Object)((Object)this.kind));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSignatureParameter other = (TypeSignatureParameter)o;
        return Objects.equals((Object)this.kind, (Object)other.kind) && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.value});
    }
}

