/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.client;

import com.facebook.presto.jdbc.internal.client.Column;
import com.facebook.presto.jdbc.internal.client.FixJsonDataUtils;
import com.facebook.presto.jdbc.internal.client.QueryData;
import com.facebook.presto.jdbc.internal.client.QueryError;
import com.facebook.presto.jdbc.internal.client.QueryStatusInfo;
import com.facebook.presto.jdbc.internal.client.StatementStats;
import com.facebook.presto.jdbc.internal.guava.base.MoreObjects;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableList;
import com.facebook.presto.jdbc.internal.guava.collect.Iterables;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.PrestoWarning;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@Immutable
public class QueryResults
implements QueryStatusInfo,
QueryData {
    private final String id;
    private final URI infoUri;
    private final URI partialCancelUri;
    private final URI nextUri;
    private final List<Column> columns;
    private final Iterable<List<Object>> data;
    private final StatementStats stats;
    private final QueryError error;
    private final List<PrestoWarning> warnings;
    private final String updateType;
    private final Long updateCount;

    @JsonCreator
    public QueryResults(@JsonProperty(value="id") String id, @JsonProperty(value="infoUri") URI infoUri, @JsonProperty(value="partialCancelUri") URI partialCancelUri, @JsonProperty(value="nextUri") URI nextUri, @JsonProperty(value="columns") List<Column> columns, @JsonProperty(value="data") List<List<Object>> data, @JsonProperty(value="stats") StatementStats stats, @JsonProperty(value="error") QueryError error, @JsonProperty(value="warnings") List<PrestoWarning> warnings, @JsonProperty(value="updateType") String updateType, @JsonProperty(value="updateCount") Long updateCount) {
        this(id, infoUri, partialCancelUri, nextUri, columns, FixJsonDataUtils.fixData(columns, data), stats, error, (List<PrestoWarning>)MoreObjects.firstNonNull(warnings, ImmutableList.of()), updateType, updateCount);
    }

    public QueryResults(String id, URI infoUri, URI partialCancelUri, URI nextUri, List<Column> columns, Iterable<List<Object>> data, StatementStats stats, QueryError error, List<PrestoWarning> warnings, String updateType, Long updateCount) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.infoUri = Objects.requireNonNull(infoUri, "infoUri is null");
        this.partialCancelUri = partialCancelUri;
        this.nextUri = nextUri;
        this.columns = columns != null ? ImmutableList.copyOf(columns) : null;
        this.data = data != null ? Iterables.unmodifiableIterable(data) : null;
        Preconditions.checkArgument(data == null || columns != null, "data present without columns");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.error = error;
        this.warnings = ImmutableList.copyOf((Collection)Objects.requireNonNull(warnings, "warnings is null"));
        this.updateType = updateType;
        this.updateCount = updateCount;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public URI getInfoUri() {
        return this.infoUri;
    }

    @Override
    @Nullable
    @JsonProperty
    public URI getPartialCancelUri() {
        return this.partialCancelUri;
    }

    @Override
    @Nullable
    @JsonProperty
    public URI getNextUri() {
        return this.nextUri;
    }

    @Override
    @Nullable
    @JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    @Nullable
    @JsonProperty
    public Iterable<List<Object>> getData() {
        return this.data;
    }

    @Override
    @JsonProperty
    public StatementStats getStats() {
        return this.stats;
    }

    @Override
    @Nullable
    @JsonProperty
    public QueryError getError() {
        return this.error;
    }

    @Override
    @JsonProperty
    public List<PrestoWarning> getWarnings() {
        return this.warnings;
    }

    @Override
    @Nullable
    @JsonProperty
    public String getUpdateType() {
        return this.updateType;
    }

    @Override
    @Nullable
    @JsonProperty
    public Long getUpdateCount() {
        return this.updateCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("infoUri", this.infoUri).add("partialCancelUri", this.partialCancelUri).add("nextUri", this.nextUri).add("columns", this.columns).add("hasData", this.data != null).add("stats", this.stats).add("error", this.error).add("updateType", this.updateType).add("updateCount", this.updateCount).toString();
    }
}

