/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.internal.guava.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class StageStats {
    private final String stageId;
    private final String state;
    private final boolean done;
    private final int nodes;
    private final int totalSplits;
    private final int queuedSplits;
    private final int runningSplits;
    private final int completedSplits;
    private final long cpuTimeMillis;
    private final long wallTimeMillis;
    private final long processedRows;
    private final long processedBytes;
    private final List<StageStats> subStages;

    public StageStats(String stageId, String state, boolean done, int nodes, int totalSplits, int queuedSplits, int runningSplits, int completedSplits, long cpuTimeMillis, long wallTimeMillis, long processedRows, long processedBytes, List<StageStats> subStages) {
        this.stageId = Objects.requireNonNull(stageId, "stageId is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.done = done;
        this.nodes = nodes;
        this.totalSplits = totalSplits;
        this.queuedSplits = queuedSplits;
        this.runningSplits = runningSplits;
        this.completedSplits = completedSplits;
        this.cpuTimeMillis = cpuTimeMillis;
        this.wallTimeMillis = wallTimeMillis;
        this.processedRows = processedRows;
        this.processedBytes = processedBytes;
        this.subStages = ImmutableList.copyOf((Collection)Objects.requireNonNull(subStages, "subStages is null"));
    }

    static StageStats create(com.facebook.presto.jdbc.internal.client.StageStats stats) {
        return new StageStats(stats.getStageId(), stats.getState(), stats.isDone(), stats.getNodes(), stats.getTotalSplits(), stats.getQueuedSplits(), stats.getRunningSplits(), stats.getCompletedSplits(), stats.getCpuTimeMillis(), stats.getWallTimeMillis(), stats.getProcessedRows(), stats.getProcessedBytes(), stats.getSubStages().stream().map(StageStats::create).collect(Collectors.toList()));
    }

    public String getStageId() {
        return this.stageId;
    }

    public String getState() {
        return this.state;
    }

    public boolean isDone() {
        return this.done;
    }

    public int getNodes() {
        return this.nodes;
    }

    public int getTotalSplits() {
        return this.totalSplits;
    }

    public int getQueuedSplits() {
        return this.queuedSplits;
    }

    public int getRunningSplits() {
        return this.runningSplits;
    }

    public int getCompletedSplits() {
        return this.completedSplits;
    }

    public long getCpuTimeMillis() {
        return this.cpuTimeMillis;
    }

    public long getWallTimeMillis() {
        return this.wallTimeMillis;
    }

    public long getProcessedRows() {
        return this.processedRows;
    }

    public long getProcessedBytes() {
        return this.processedBytes;
    }

    public List<StageStats> getSubStages() {
        return this.subStages;
    }
}

