/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps.internal;

import com.ejlchina.data.Array;
import com.ejlchina.data.Mapper;
import com.ejlchina.data.TypeRef;
import com.ejlchina.okhttps.HttpCall;
import com.ejlchina.okhttps.HttpResult;
import com.ejlchina.okhttps.HttpTask;
import com.ejlchina.okhttps.OnCallback;
import com.ejlchina.okhttps.internal.HttpClient;
import com.ejlchina.okhttps.internal.HttpException;
import com.ejlchina.okhttps.internal.RealHttpResult;
import com.ejlchina.okhttps.internal.TaskExecutor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class AsyncHttpTask
extends HttpTask<AsyncHttpTask> {
    private OnCallback<HttpResult> onResponse;
    private OnCallback<IOException> onException;
    private OnCallback<HttpResult.State> onComplete;
    private boolean responseOnIO;
    private boolean exceptionOnIO;
    private boolean completeOnIO;
    private OnCallback<HttpResult.Body> onResBody;
    private OnCallback<Mapper> onResMapper;
    private OnCallback<Array> onResArray;
    private OnCallback<String> onResString;
    private OnCallback<?> onResBean;
    private OnCallback<?> onResList;
    private boolean resBodyOnIO;
    private boolean resMapperOnIO;
    private boolean resArrayOnIO;
    private boolean resStringOnIO;
    private boolean resBeanOnIO;
    private boolean resListOnIO;
    private Type beanType;
    private Class<?> listType;
    static final String OnCallbackMethod = OnCallback.class.getDeclaredMethods()[0].getName();

    public AsyncHttpTask(HttpClient client, String url) {
        super(client, url);
    }

    @Override
    public boolean isAsyncHttp() {
        return true;
    }

    public AsyncHttpTask setOnException(OnCallback<IOException> onException) {
        this.onException = onException;
        this.exceptionOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public AsyncHttpTask setOnComplete(OnCallback<HttpResult.State> onComplete) {
        this.onComplete = onComplete;
        this.completeOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public synchronized AsyncHttpTask setOnResponse(OnCallback<HttpResult> onResponse) {
        this.onResponse = onResponse;
        this.responseOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public synchronized AsyncHttpTask setOnResBody(OnCallback<HttpResult.Body> onResBody) {
        this.onResBody = onResBody;
        this.resBodyOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public synchronized <T> AsyncHttpTask setOnResBean(Class<T> type, OnCallback<T> onResBean) {
        this.initBeanType(type);
        this.onResBean = onResBean;
        this.resBeanOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public synchronized <T> AsyncHttpTask setOnResBean(TypeRef<T> type, OnCallback<T> onResBean) {
        this.initBeanType(type.getType());
        this.onResBean = onResBean;
        this.resBeanOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public synchronized <T> AsyncHttpTask setOnResList(Class<T> type, OnCallback<List<T>> onResList) {
        if (type == null) {
            throw new IllegalArgumentException(" list type can not be null!");
        }
        this.listType = type;
        this.onResList = onResList;
        this.resListOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public synchronized AsyncHttpTask setOnResMapper(OnCallback<Mapper> onResMapper) {
        this.onResMapper = onResMapper;
        this.resMapperOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public synchronized AsyncHttpTask setOnResArray(OnCallback<Array> onResArray) {
        this.onResArray = onResArray;
        this.resArrayOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public synchronized AsyncHttpTask setOnResString(OnCallback<String> onResString) {
        this.onResString = onResString;
        this.resStringOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public HttpCall get() {
        return this.request("GET");
    }

    public HttpCall head() {
        return this.request("HEAD");
    }

    public HttpCall post() {
        return this.request("POST");
    }

    public HttpCall put() {
        return this.request("PUT");
    }

    public HttpCall patch() {
        return this.request("PATCH");
    }

    public HttpCall delete() {
        return this.request("DELETE");
    }

    public HttpCall request(String method) {
        if (method == null || method.isEmpty()) {
            throw new IllegalArgumentException("HTTP \u8bf7\u6c42\u65b9\u6cd5 method \u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        PreHttpCall call = new PreHttpCall();
        this.registeTagTask(call);
        this.httpClient.preprocess(this, () -> {
            PreHttpCall preHttpCall = call;
            synchronized (preHttpCall) {
                if (call.canceled) {
                    this.removeTagTask();
                } else {
                    if (this.onResponse != null || this.onResBody != null) {
                        this.tag("okhttps-Async-Response-Copy");
                    }
                    call.setCall(this.executeCall(this.prepareCall(method)));
                }
            }
        }, this.skipPreproc, this.skipSerialPreproc);
        return call;
    }

    private HttpCall executeCall(Call call) {
        final OkHttpCall httpCall = new OkHttpCall(call);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException error) {
                HttpResult.State state = AsyncHttpTask.this.toState(error);
                RealHttpResult result = new RealHttpResult(AsyncHttpTask.this, state, error);
                AsyncHttpTask.this.onCallback(httpCall, result, () -> {
                    TaskExecutor executor = AsyncHttpTask.this.httpClient.executor();
                    executor.executeOnComplete(AsyncHttpTask.this, AsyncHttpTask.this.onComplete, state, AsyncHttpTask.this.completeOnIO);
                    if (!executor.executeOnException(AsyncHttpTask.this, AsyncHttpTask.this.onException, error, AsyncHttpTask.this.exceptionOnIO) && !AsyncHttpTask.this.nothrow) {
                        throw new HttpException(state, "\u5f02\u6b65\u8bf7\u6c42\u5f02\u5e38\uff1a" + AsyncHttpTask.this.getUrl(), error);
                    }
                });
            }

            public void onResponse(Call call, Response response) {
                TaskExecutor executor = AsyncHttpTask.this.httpClient.executor();
                RealHttpResult result = new RealHttpResult(AsyncHttpTask.this, response, executor);
                AsyncHttpTask.this.onCallback(httpCall, result, () -> {
                    executor.executeOnComplete(AsyncHttpTask.this, AsyncHttpTask.this.onComplete, HttpResult.State.RESPONSED, AsyncHttpTask.this.completeOnIO);
                    executor.executeOnResponse(AsyncHttpTask.this, AsyncHttpTask.this.complexOnResponse(), result, true);
                });
            }
        });
        return httpCall;
    }

    private synchronized OnCallback<HttpResult> complexOnResponse() {
        return res -> {
            OnCallback<String> listener7;
            OnCallback<?> listener6;
            OnCallback<?> listener5;
            OnCallback<Array> listener4;
            OnCallback<Mapper> listener3;
            OnCallback<HttpResult.Body> listener2;
            OnCallback<HttpResult> listener1;
            int count = this.responseCallbackCount();
            HttpResult.Body body = res.getBody();
            if (count > 1) {
                body.cache();
            }
            if ((listener1 = this.onResponse) != null) {
                this.execute(() -> listener1.on((HttpResult)res), this.responseOnIO);
            }
            if ((listener2 = this.onResBody) != null) {
                this.execute(() -> listener2.on(body), this.resBodyOnIO);
            }
            if ((listener3 = this.onResMapper) != null) {
                Mapper mapper = body.toMapper();
                this.execute(() -> listener3.on(mapper), this.resMapperOnIO);
            }
            if ((listener4 = this.onResArray) != null) {
                Array array = body.toArray();
                this.execute(() -> listener4.on(array), this.resArrayOnIO);
            }
            if ((listener5 = this.onResBean) != null) {
                Object bean = body.toBean(this.beanType);
                this.execute(() -> {
                    try {
                        this.callbackMethod(listener5.getClass(), bean.getClass()).invoke((Object)listener5, bean);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new HttpException("\u56de\u8c03\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01", e);
                    }
                }, this.resBeanOnIO);
            }
            if ((listener6 = this.onResList) != null) {
                List<?> list = body.toList(this.listType);
                this.execute(() -> {
                    try {
                        this.callbackMethod(listener6.getClass(), list.getClass()).invoke((Object)listener6, list);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new HttpException("\u56de\u8c03\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01", e);
                    }
                }, this.resListOnIO);
            }
            if ((listener7 = this.onResString) != null) {
                String string = body.toString();
                this.execute(() -> listener7.on(string), this.resStringOnIO);
            }
        };
    }

    private Method callbackMethod(Class<?> clazz, Class<?> paraType) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Class<?>[] paraTypes = method.getParameterTypes();
            if (!method.getName().equals(OnCallbackMethod) || paraTypes.length != 1 || !paraTypes[0].isAssignableFrom(paraType)) continue;
            method.setAccessible(true);
            return method;
        }
        throw new IllegalStateException("\u6ca1\u6709\u53ef\u8c03\u7528\u7684\u65b9\u6cd5");
    }

    private int responseCallbackCount() {
        int count = 0;
        if (this.onResponse != null) {
            ++count;
        }
        if (this.onResBody != null) {
            ++count;
        }
        if (this.onResMapper != null) {
            ++count;
        }
        if (this.onResArray != null) {
            ++count;
        }
        if (this.onResBean != null) {
            ++count;
        }
        if (this.onResList != null) {
            ++count;
        }
        if (this.onResString != null) {
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCallback(OkHttpCall httpCall, HttpResult result, Runnable runnable) {
        OkHttpCall okHttpCall = httpCall;
        synchronized (okHttpCall) {
            this.removeTagTask();
            if (httpCall.isCanceled() || result.getState() == HttpResult.State.CANCELED) {
                httpCall.setResult(new RealHttpResult(this, HttpResult.State.CANCELED));
                return;
            }
            httpCall.setResult(result);
            runnable.run();
        }
    }

    private void initBeanType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException(" bean type can not be null!");
        }
        if (this.beanType != null) {
            throw new IllegalStateException("\u5df2\u7ecf\u6dfb\u52a0\u4e86 OnResBean \u56de\u8c03\uff01");
        }
        this.beanType = type;
    }

    class OkHttpCall
    implements HttpCall {
        Call call;
        HttpResult result;
        CountDownLatch latch = new CountDownLatch(1);

        OkHttpCall(Call call) {
            this.call = call;
        }

        @Override
        public synchronized boolean cancel() {
            if (this.result == null) {
                this.call.cancel();
                return true;
            }
            return false;
        }

        @Override
        public boolean isDone() {
            return this.result != null;
        }

        @Override
        public boolean isCanceled() {
            return this.call.isCanceled();
        }

        @Override
        public HttpResult getResult() {
            if (this.result == null && !AsyncHttpTask.this.timeoutAwait(this.latch)) {
                this.cancel();
                return AsyncHttpTask.this.timeoutResult();
            }
            return this.result;
        }

        @Override
        public AsyncHttpTask getTask() {
            return AsyncHttpTask.this;
        }

        void setResult(HttpResult result) {
            this.result = result;
            this.latch.countDown();
        }
    }

    class PreHttpCall
    implements HttpCall {
        HttpCall call;
        boolean canceled = false;
        CountDownLatch latch = new CountDownLatch(1);

        PreHttpCall() {
        }

        @Override
        public synchronized boolean cancel() {
            this.canceled = this.call == null || this.call.cancel();
            this.latch.countDown();
            return this.canceled;
        }

        @Override
        public boolean isDone() {
            if (this.call != null) {
                return this.call.isDone();
            }
            return this.canceled;
        }

        @Override
        public boolean isCanceled() {
            return this.canceled;
        }

        void setCall(HttpCall call) {
            this.call = call;
            this.latch.countDown();
        }

        @Override
        public HttpResult getResult() {
            if (!AsyncHttpTask.this.timeoutAwait(this.latch)) {
                this.cancel();
                return AsyncHttpTask.this.timeoutResult();
            }
            if (this.canceled || this.call == null) {
                return new RealHttpResult(AsyncHttpTask.this, HttpResult.State.CANCELED);
            }
            return this.call.getResult();
        }

        @Override
        public AsyncHttpTask getTask() {
            return AsyncHttpTask.this;
        }
    }
}

