/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.tsp.cms;

import com.donjin.org.bouncycastle.asn1.ASN1Boolean;
import com.donjin.org.bouncycastle.asn1.DERIA5String;
import com.donjin.org.bouncycastle.asn1.DERUTF8String;
import com.donjin.org.bouncycastle.asn1.cms.Attributes;
import com.donjin.org.bouncycastle.asn1.cms.MetaData;
import com.donjin.org.bouncycastle.cms.CMSException;
import com.donjin.org.bouncycastle.operator.DigestCalculator;
import com.donjin.org.bouncycastle.tsp.cms.MetaDataUtil;
import java.net.URI;

public class CMSTimeStampedGenerator {
    protected MetaData metaData;
    protected URI dataUri;

    public void setDataUri(URI dataUri) {
        this.dataUri = dataUri;
    }

    public void setMetaData(boolean hashProtected, String fileName, String mediaType) {
        this.setMetaData(hashProtected, fileName, mediaType, null);
    }

    public void setMetaData(boolean hashProtected, String fileName, String mediaType, Attributes attributes) {
        DERUTF8String asn1FileName = null;
        if (fileName != null) {
            asn1FileName = new DERUTF8String(fileName);
        }
        DERIA5String asn1MediaType = null;
        if (mediaType != null) {
            asn1MediaType = new DERIA5String(mediaType);
        }
        this.setMetaData(hashProtected, asn1FileName, asn1MediaType, attributes);
    }

    private void setMetaData(boolean hashProtected, DERUTF8String fileName, DERIA5String mediaType, Attributes attributes) {
        this.metaData = new MetaData(ASN1Boolean.getInstance(hashProtected), fileName, mediaType, attributes);
    }

    public void initialiseMessageImprintDigestCalculator(DigestCalculator calculator) throws CMSException {
        MetaDataUtil util = new MetaDataUtil(this.metaData);
        util.initialiseMessageImprintDigestCalculator(calculator);
    }
}

