/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.tsp;

import com.donjin.org.bouncycastle.asn1.ASN1InputStream;
import com.donjin.org.bouncycastle.asn1.cms.Attribute;
import com.donjin.org.bouncycastle.asn1.cms.AttributeTable;
import com.donjin.org.bouncycastle.asn1.cms.ContentInfo;
import com.donjin.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.donjin.org.bouncycastle.asn1.ess.ESSCertID;
import com.donjin.org.bouncycastle.asn1.ess.ESSCertIDv2;
import com.donjin.org.bouncycastle.asn1.ess.SigningCertificate;
import com.donjin.org.bouncycastle.asn1.ess.SigningCertificateV2;
import com.donjin.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.donjin.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.donjin.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.donjin.org.bouncycastle.asn1.tsp.TSTInfo;
import com.donjin.org.bouncycastle.asn1.x500.X500Name;
import com.donjin.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.donjin.org.bouncycastle.asn1.x509.GeneralName;
import com.donjin.org.bouncycastle.asn1.x509.IssuerSerial;
import com.donjin.org.bouncycastle.cert.X509CertificateHolder;
import com.donjin.org.bouncycastle.cms.CMSException;
import com.donjin.org.bouncycastle.cms.CMSSignedData;
import com.donjin.org.bouncycastle.cms.CMSTypedData;
import com.donjin.org.bouncycastle.cms.SignerId;
import com.donjin.org.bouncycastle.cms.SignerInformation;
import com.donjin.org.bouncycastle.cms.SignerInformationVerifier;
import com.donjin.org.bouncycastle.operator.DigestCalculator;
import com.donjin.org.bouncycastle.operator.OperatorCreationException;
import com.donjin.org.bouncycastle.tsp.TSPException;
import com.donjin.org.bouncycastle.tsp.TSPUtil;
import com.donjin.org.bouncycastle.tsp.TSPValidationException;
import com.donjin.org.bouncycastle.tsp.TimeStampTokenInfo;
import com.donjin.org.bouncycastle.util.Arrays;
import com.donjin.org.bouncycastle.util.Store;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;

public class TimeStampToken {
    CMSSignedData tsToken;
    SignerInformation tsaSignerInfo;
    Date genTime;
    TimeStampTokenInfo tstInfo;
    CertID certID;

    public TimeStampToken(ContentInfo contentInfo) throws TSPException, IOException {
        this(TimeStampToken.getSignedData(contentInfo));
    }

    private static CMSSignedData getSignedData(ContentInfo contentInfo) throws TSPException {
        try {
            return new CMSSignedData(contentInfo);
        }
        catch (CMSException e) {
            throw new TSPException("TSP parsing error: " + e.getMessage(), e.getCause());
        }
    }

    public TimeStampToken(CMSSignedData signedData) throws TSPException, IOException {
        this.tsToken = signedData;
        if (!this.tsToken.getSignedContentTypeOID().equals(PKCSObjectIdentifiers.id_ct_TSTInfo.getId())) {
            throw new TSPValidationException("ContentInfo object not for a time stamp.");
        }
        Collection<SignerInformation> signers = this.tsToken.getSignerInfos().getSigners();
        if (signers.size() != 1) {
            throw new IllegalArgumentException("Time-stamp token signed by " + signers.size() + " signers, but it must contain just the TSA signature.");
        }
        this.tsaSignerInfo = signers.iterator().next();
        try {
            CMSTypedData content = this.tsToken.getSignedContent();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            content.write(bOut);
            ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(bOut.toByteArray()));
            this.tstInfo = new TimeStampTokenInfo(TSTInfo.getInstance(aIn.readObject()));
            Attribute attr = this.tsaSignerInfo.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificate);
            if (attr != null) {
                SigningCertificate signCert = SigningCertificate.getInstance(attr.getAttrValues().getObjectAt(0));
                this.certID = new CertID(ESSCertID.getInstance(signCert.getCerts()[0]));
            } else {
                attr = this.tsaSignerInfo.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
                if (attr == null) {
                    throw new TSPValidationException("no signing certificate attribute found, time stamp invalid.");
                }
                SigningCertificateV2 signCertV2 = SigningCertificateV2.getInstance(attr.getAttrValues().getObjectAt(0));
                this.certID = new CertID(ESSCertIDv2.getInstance(signCertV2.getCerts()[0]));
            }
        }
        catch (CMSException e) {
            throw new TSPException(e.getMessage(), e.getUnderlyingException());
        }
    }

    public TimeStampTokenInfo getTimeStampInfo() {
        return this.tstInfo;
    }

    public SignerId getSID() {
        return this.tsaSignerInfo.getSID();
    }

    public AttributeTable getSignedAttributes() {
        return this.tsaSignerInfo.getSignedAttributes();
    }

    public AttributeTable getUnsignedAttributes() {
        return this.tsaSignerInfo.getUnsignedAttributes();
    }

    public Store getCertificates() {
        return this.tsToken.getCertificates();
    }

    public Store getCRLs() {
        return this.tsToken.getCRLs();
    }

    public Store getAttributeCertificates() {
        return this.tsToken.getAttributeCertificates();
    }

    public void validate(SignerInformationVerifier sigVerifier) throws TSPException, TSPValidationException {
        if (!sigVerifier.hasAssociatedCertificate()) {
            throw new IllegalArgumentException("verifier provider needs an associated certificate");
        }
        try {
            X509CertificateHolder certHolder = sigVerifier.getAssociatedCertificate();
            DigestCalculator calc = sigVerifier.getDigestCalculator(this.certID.getHashAlgorithm());
            OutputStream cOut = calc.getOutputStream();
            cOut.write(certHolder.getEncoded());
            cOut.close();
            if (!Arrays.constantTimeAreEqual(this.certID.getCertHash(), calc.getDigest())) {
                throw new TSPValidationException("certificate hash does not match certID hash.");
            }
            if (this.certID.getIssuerSerial() != null) {
                IssuerAndSerialNumber issuerSerial = new IssuerAndSerialNumber(certHolder.toASN1Structure());
                if (!this.certID.getIssuerSerial().getSerial().equals(issuerSerial.getSerialNumber())) {
                    throw new TSPValidationException("certificate serial number does not match certID for signature.");
                }
                GeneralName[] names = this.certID.getIssuerSerial().getIssuer().getNames();
                boolean found = false;
                int i = 0;
                while (i != names.length) {
                    if (names[i].getTagNo() == 4 && X500Name.getInstance(names[i].getName()).equals(X500Name.getInstance(issuerSerial.getName()))) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    throw new TSPValidationException("certificate name does not match certID for signature. ");
                }
            }
            TSPUtil.validateCertificate(certHolder);
            if (!certHolder.isValidOn(this.tstInfo.getGenTime())) {
                throw new TSPValidationException("certificate not valid when time stamp created.");
            }
            if (!this.tsaSignerInfo.verify(sigVerifier)) {
                throw new TSPValidationException("signature not created by certificate.");
            }
        }
        catch (CMSException e) {
            if (e.getUnderlyingException() != null) {
                throw new TSPException(e.getMessage(), e.getUnderlyingException());
            }
            throw new TSPException("CMS exception: " + e, e);
        }
        catch (IOException e) {
            throw new TSPException("problem processing certificate: " + e, e);
        }
        catch (OperatorCreationException e) {
            throw new TSPException("unable to create digest: " + e.getMessage(), e);
        }
    }

    public boolean isSignatureValid(SignerInformationVerifier sigVerifier) throws TSPException {
        try {
            return this.tsaSignerInfo.verify(sigVerifier);
        }
        catch (CMSException e) {
            if (e.getUnderlyingException() != null) {
                throw new TSPException(e.getMessage(), e.getUnderlyingException());
            }
            throw new TSPException("CMS exception: " + e, e);
        }
    }

    public CMSSignedData toCMSSignedData() {
        return this.tsToken;
    }

    public byte[] getEncoded() throws IOException {
        return this.tsToken.getEncoded();
    }

    private class CertID {
        private ESSCertID certID;
        private ESSCertIDv2 certIDv2;

        CertID(ESSCertID certID) {
            this.certID = certID;
            this.certIDv2 = null;
        }

        CertID(ESSCertIDv2 certID) {
            this.certIDv2 = certID;
            this.certID = null;
        }

        public String getHashAlgorithmName() {
            if (this.certID != null) {
                return "SHA-1";
            }
            if (NISTObjectIdentifiers.id_sha256.equals(this.certIDv2.getHashAlgorithm().getAlgorithm())) {
                return "SHA-256";
            }
            return this.certIDv2.getHashAlgorithm().getAlgorithm().getId();
        }

        public AlgorithmIdentifier getHashAlgorithm() {
            if (this.certID != null) {
                return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
            }
            return this.certIDv2.getHashAlgorithm();
        }

        public byte[] getCertHash() {
            if (this.certID != null) {
                return this.certID.getCertHash();
            }
            return this.certIDv2.getCertHash();
        }

        public IssuerSerial getIssuerSerial() {
            if (this.certID != null) {
                return this.certID.getIssuerSerial();
            }
            return this.certIDv2.getIssuerSerial();
        }
    }
}

