/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.math.ntru.polynomial;

import com.donjin.org.bouncycastle.pqc.math.ntru.polynomial.BigIntPolynomial;
import com.donjin.org.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.donjin.org.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import com.donjin.org.bouncycastle.pqc.math.ntru.polynomial.SparseTernaryPolynomial;
import com.donjin.org.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;

public class ProductFormPolynomial
implements Polynomial {
    private SparseTernaryPolynomial f1;
    private SparseTernaryPolynomial f2;
    private SparseTernaryPolynomial f3;

    public ProductFormPolynomial(SparseTernaryPolynomial f1, SparseTernaryPolynomial f2, SparseTernaryPolynomial f3) {
        this.f1 = f1;
        this.f2 = f2;
        this.f3 = f3;
    }

    public static ProductFormPolynomial generateRandom(int N, int df1, int df2, int df3Ones, int df3NegOnes, SecureRandom random) {
        SparseTernaryPolynomial f1 = SparseTernaryPolynomial.generateRandom(N, df1, df1, random);
        SparseTernaryPolynomial f2 = SparseTernaryPolynomial.generateRandom(N, df2, df2, random);
        SparseTernaryPolynomial f3 = SparseTernaryPolynomial.generateRandom(N, df3Ones, df3NegOnes, random);
        return new ProductFormPolynomial(f1, f2, f3);
    }

    public static ProductFormPolynomial fromBinary(byte[] data, int N, int df1, int df2, int df3Ones, int df3NegOnes) throws IOException {
        return ProductFormPolynomial.fromBinary(new ByteArrayInputStream(data), N, df1, df2, df3Ones, df3NegOnes);
    }

    public static ProductFormPolynomial fromBinary(InputStream is, int N, int df1, int df2, int df3Ones, int df3NegOnes) throws IOException {
        SparseTernaryPolynomial f1 = SparseTernaryPolynomial.fromBinary(is, N, df1, df1);
        SparseTernaryPolynomial f2 = SparseTernaryPolynomial.fromBinary(is, N, df2, df2);
        SparseTernaryPolynomial f3 = SparseTernaryPolynomial.fromBinary(is, N, df3Ones, df3NegOnes);
        return new ProductFormPolynomial(f1, f2, f3);
    }

    public byte[] toBinary() {
        byte[] f1Bin = this.f1.toBinary();
        byte[] f2Bin = this.f2.toBinary();
        byte[] f3Bin = this.f3.toBinary();
        byte[] all = Arrays.copyOf(f1Bin, f1Bin.length + f2Bin.length + f3Bin.length);
        System.arraycopy(f2Bin, 0, all, f1Bin.length, f2Bin.length);
        System.arraycopy(f3Bin, 0, all, f1Bin.length + f2Bin.length, f3Bin.length);
        return all;
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial b) {
        IntegerPolynomial c = this.f1.mult(b);
        c = this.f2.mult(c);
        c.add(this.f3.mult(b));
        return c;
    }

    @Override
    public BigIntPolynomial mult(BigIntPolynomial b) {
        BigIntPolynomial c = this.f1.mult(b);
        c = this.f2.mult(c);
        c.add(this.f3.mult(b));
        return c;
    }

    @Override
    public IntegerPolynomial toIntegerPolynomial() {
        IntegerPolynomial i = this.f1.mult(this.f2.toIntegerPolynomial());
        i.add(this.f3.toIntegerPolynomial());
        return i;
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial poly2, int modulus) {
        IntegerPolynomial c = this.mult(poly2);
        c.mod(modulus);
        return c;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.f1 == null ? 0 : this.f1.hashCode());
        result = 31 * result + (this.f2 == null ? 0 : this.f2.hashCode());
        result = 31 * result + (this.f3 == null ? 0 : this.f3.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductFormPolynomial other = (ProductFormPolynomial)obj;
        if (this.f1 == null ? other.f1 != null : !this.f1.equals(other.f1)) {
            return false;
        }
        if (this.f2 == null ? other.f2 != null : !this.f2.equals(other.f2)) {
            return false;
        }
        return !(this.f3 == null ? other.f3 != null : !this.f3.equals(other.f3));
    }
}

