/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.math.ntru.polynomial;

import com.donjin.org.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.donjin.org.bouncycastle.pqc.math.ntru.polynomial.TernaryPolynomial;
import com.donjin.org.bouncycastle.util.Arrays;

public class LongPolynomial5 {
    private long[] coeffs;
    private int numCoeffs;

    public LongPolynomial5(IntegerPolynomial p) {
        this.numCoeffs = p.coeffs.length;
        this.coeffs = new long[(this.numCoeffs + 4) / 5];
        int cIdx = 0;
        int shift = 0;
        int i = 0;
        while (i < this.numCoeffs) {
            int n = cIdx++;
            this.coeffs[n] = this.coeffs[n] | (long)p.coeffs[i] << shift;
            if ((shift += 12) >= 60) {
                shift = 0;
            }
            ++i;
        }
    }

    private LongPolynomial5(long[] coeffs, int numCoeffs) {
        this.coeffs = coeffs;
        this.numCoeffs = numCoeffs;
    }

    public LongPolynomial5 mult(TernaryPolynomial poly2) {
        int cIdx;
        long[][] prod = new long[5][this.coeffs.length + (poly2.size() + 4) / 5 - 1];
        int[] ones = poly2.getOnes();
        int idx = 0;
        while (idx != ones.length) {
            int pIdx = ones[idx];
            int cIdx2 = pIdx / 5;
            int m = pIdx - cIdx2 * 5;
            int i = 0;
            while (i < this.coeffs.length) {
                prod[m][cIdx2] = prod[m][cIdx2] + this.coeffs[i] & 0x7FF7FF7FF7FF7FFL;
                ++cIdx2;
                ++i;
            }
            ++idx;
        }
        int[] negOnes = poly2.getNegOnes();
        int idx2 = 0;
        while (idx2 != negOnes.length) {
            int pIdx = negOnes[idx2];
            cIdx = pIdx / 5;
            int m = pIdx - cIdx * 5;
            int i = 0;
            while (i < this.coeffs.length) {
                prod[m][cIdx] = 0x800800800800800L + prod[m][cIdx] - this.coeffs[i] & 0x7FF7FF7FF7FF7FFL;
                ++cIdx;
                ++i;
            }
            ++idx2;
        }
        long[] cCoeffs = Arrays.copyOf(prod[0], prod[0].length + 1);
        int m = 1;
        while (m <= 4) {
            int shift = m * 12;
            int shift60 = 60 - shift;
            long mask = (1L << shift60) - 1L;
            int pLen = prod[m].length;
            int i = 0;
            while (i < pLen) {
                long upper = prod[m][i] >> shift60;
                long lower = prod[m][i] & mask;
                cCoeffs[i] = cCoeffs[i] + (lower << shift) & 0x7FF7FF7FF7FF7FFL;
                int nextIdx = i + 1;
                cCoeffs[nextIdx] = cCoeffs[nextIdx] + upper & 0x7FF7FF7FF7FF7FFL;
                ++i;
            }
            ++m;
        }
        int shift = 12 * (this.numCoeffs % 5);
        cIdx = this.coeffs.length - 1;
        while (cIdx < cCoeffs.length) {
            int newIdx;
            long iCoeff;
            if (cIdx == this.coeffs.length - 1) {
                iCoeff = this.numCoeffs == 5 ? 0L : cCoeffs[cIdx] >> shift;
                newIdx = 0;
            } else {
                iCoeff = cCoeffs[cIdx];
                newIdx = cIdx * 5 - this.numCoeffs;
            }
            int base = newIdx / 5;
            int m2 = newIdx - base * 5;
            long lower = iCoeff << 12 * m2;
            long upper = iCoeff >> 12 * (5 - m2);
            cCoeffs[base] = cCoeffs[base] + lower & 0x7FF7FF7FF7FF7FFL;
            int base1 = base + 1;
            if (base1 < this.coeffs.length) {
                cCoeffs[base1] = cCoeffs[base1] + upper & 0x7FF7FF7FF7FF7FFL;
            }
            ++cIdx;
        }
        return new LongPolynomial5(cCoeffs, this.numCoeffs);
    }

    public IntegerPolynomial toIntegerPolynomial() {
        int[] intCoeffs = new int[this.numCoeffs];
        int cIdx = 0;
        int shift = 0;
        int i = 0;
        while (i < this.numCoeffs) {
            intCoeffs[i] = (int)(this.coeffs[cIdx] >> shift & 0x7FFL);
            if ((shift += 12) >= 60) {
                shift = 0;
                ++cIdx;
            }
            ++i;
        }
        return new IntegerPolynomial(intCoeffs);
    }
}

