/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.math.linearalgebra;

import com.donjin.org.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.donjin.org.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import com.donjin.org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.donjin.org.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.donjin.org.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.security.SecureRandom;

public final class GoppaCode {
    private GoppaCode() {
    }

    public static GF2Matrix createCanonicalCheckMatrix(GF2mField field, PolynomialGF2mSmallM gp) {
        int j;
        int m = field.getDegree();
        int n = 1 << m;
        int t = gp.getDegree();
        int[][] hArray = new int[t][n];
        int[][] yz = new int[t][n];
        int j2 = 0;
        while (j2 < n) {
            yz[0][j2] = field.inverse(gp.evaluateAt(j2));
            ++j2;
        }
        int i = 1;
        while (i < t) {
            j = 0;
            while (j < n) {
                yz[i][j] = field.mult(yz[i - 1][j], j);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < t) {
            j = 0;
            while (j < n) {
                int k = 0;
                while (k <= i) {
                    hArray[i][j] = field.add(hArray[i][j], field.mult(yz[k][j], gp.getCoefficient(t + k - i)));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int[][] result = new int[t * m][n + 31 >>> 5];
        j = 0;
        while (j < n) {
            int q = j >>> 5;
            int r = 1 << (j & 0x1F);
            int i2 = 0;
            while (i2 < t) {
                int e = hArray[i2][j];
                int u = 0;
                while (u < m) {
                    int b = e >>> u & 1;
                    if (b != 0) {
                        int ind = (i2 + 1) * m - u - 1;
                        int[] nArray = result[ind];
                        int n2 = q;
                        nArray[n2] = nArray[n2] ^ r;
                    }
                    ++u;
                }
                ++i2;
            }
            ++j;
        }
        return new GF2Matrix(n, result);
    }

    public static MaMaPe computeSystematicForm(GF2Matrix h, SecureRandom sr) {
        GF2Matrix sInv;
        GF2Matrix hp;
        Permutation p;
        int n = h.getNumColumns();
        GF2Matrix s = null;
        boolean found = false;
        do {
            p = new Permutation(n, sr);
            hp = (GF2Matrix)h.rightMultiply(p);
            sInv = hp.getLeftSubMatrix();
            try {
                found = true;
                s = (GF2Matrix)sInv.computeInverse();
            }
            catch (ArithmeticException ae) {
                found = false;
            }
        } while (!found);
        GF2Matrix shp = (GF2Matrix)s.rightMultiply(hp);
        GF2Matrix m = shp.getRightSubMatrix();
        return new MaMaPe(sInv, m, p);
    }

    public static GF2Vector syndromeDecode(GF2Vector syndVec, GF2mField field, PolynomialGF2mSmallM gp, PolynomialGF2mSmallM[] sqRootMatrix) {
        int n = 1 << field.getDegree();
        GF2Vector errors = new GF2Vector(n);
        if (!syndVec.isZero()) {
            PolynomialGF2mSmallM syndrome = new PolynomialGF2mSmallM(syndVec.toExtensionFieldVector(field));
            PolynomialGF2mSmallM t = syndrome.modInverse(gp);
            PolynomialGF2mSmallM tau = t.addMonomial(1);
            tau = tau.modSquareRootMatrix(sqRootMatrix);
            PolynomialGF2mSmallM[] ab = tau.modPolynomialToFracton(gp);
            PolynomialGF2mSmallM a2 = ab[0].multiply(ab[0]);
            PolynomialGF2mSmallM b2 = ab[1].multiply(ab[1]);
            PolynomialGF2mSmallM xb2 = b2.multWithMonomial(1);
            PolynomialGF2mSmallM a2plusXb2 = a2.add(xb2);
            int headCoeff = a2plusXb2.getHeadCoefficient();
            int invHeadCoeff = field.inverse(headCoeff);
            PolynomialGF2mSmallM elp = a2plusXb2.multWithElement(invHeadCoeff);
            int i = 0;
            while (i < n) {
                int z = elp.evaluateAt(i);
                if (z == 0) {
                    errors.setBit(i);
                }
                ++i;
            }
        }
        return errors;
    }

    public static class MaMaPe {
        private GF2Matrix s;
        private GF2Matrix h;
        private Permutation p;

        public MaMaPe(GF2Matrix s, GF2Matrix h, Permutation p) {
            this.s = s;
            this.h = h;
            this.p = p;
        }

        public GF2Matrix getFirstMatrix() {
            return this.s;
        }

        public GF2Matrix getSecondMatrix() {
            return this.h;
        }

        public Permutation getPermutation() {
            return this.p;
        }
    }

    public static class MatrixSet {
        private GF2Matrix g;
        private int[] setJ;

        public MatrixSet(GF2Matrix g, int[] setJ) {
            this.g = g;
            this.setJ = setJ;
        }

        public GF2Matrix getG() {
            return this.g;
        }

        public int[] getSetJ() {
            return this.setJ;
        }
    }
}

