/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.math.linearalgebra;

import com.donjin.org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.donjin.org.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.donjin.org.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.donjin.org.bouncycastle.pqc.math.linearalgebra.Vector;

public class GF2mVector
extends Vector {
    private GF2mField field;
    private int[] vector;

    public GF2mVector(GF2mField field, byte[] v) {
        this.field = new GF2mField(field);
        int d = 8;
        int count = 1;
        while (field.getDegree() > d) {
            ++count;
            d += 8;
        }
        if (v.length % count != 0) {
            throw new IllegalArgumentException("Byte array is not an encoded vector over the given finite field.");
        }
        this.length = v.length / count;
        this.vector = new int[this.length];
        count = 0;
        int i = 0;
        while (i < this.vector.length) {
            int j = 0;
            while (j < d) {
                int n = i;
                this.vector[n] = this.vector[n] | (v[count++] & 0xFF) << j;
                j += 8;
            }
            if (!field.isElementOfThisField(this.vector[i])) {
                throw new IllegalArgumentException("Byte array is not an encoded vector over the given finite field.");
            }
            ++i;
        }
    }

    public GF2mVector(GF2mField field, int[] vector) {
        this.field = field;
        this.length = vector.length;
        int i = vector.length - 1;
        while (i >= 0) {
            if (!field.isElementOfThisField(vector[i])) {
                throw new ArithmeticException("Element array is not specified over the given finite field.");
            }
            --i;
        }
        this.vector = IntUtils.clone(vector);
    }

    public GF2mVector(GF2mVector other) {
        this.field = new GF2mField(other.field);
        this.length = other.length;
        this.vector = IntUtils.clone(other.vector);
    }

    public GF2mField getField() {
        return this.field;
    }

    public int[] getIntArrayForm() {
        return IntUtils.clone(this.vector);
    }

    @Override
    public byte[] getEncoded() {
        int d = 8;
        int count = 1;
        while (this.field.getDegree() > d) {
            ++count;
            d += 8;
        }
        byte[] res = new byte[this.vector.length * count];
        count = 0;
        int i = 0;
        while (i < this.vector.length) {
            int j = 0;
            while (j < d) {
                res[count++] = (byte)(this.vector[i] >>> j);
                j += 8;
            }
            ++i;
        }
        return res;
    }

    @Override
    public boolean isZero() {
        int i = this.vector.length - 1;
        while (i >= 0) {
            if (this.vector[i] != 0) {
                return false;
            }
            --i;
        }
        return true;
    }

    @Override
    public Vector add(Vector addend) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Vector multiply(Permutation p) {
        int[] pVec = p.getVector();
        if (this.length != pVec.length) {
            throw new ArithmeticException("permutation size and vector size mismatch");
        }
        int[] result = new int[this.length];
        int i = 0;
        while (i < pVec.length) {
            result[i] = this.vector[pVec[i]];
            ++i;
        }
        return new GF2mVector(this.field, result);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GF2mVector)) {
            return false;
        }
        GF2mVector otherVec = (GF2mVector)other;
        if (!this.field.equals(otherVec.field)) {
            return false;
        }
        return IntUtils.equals(this.vector, otherVec.vector);
    }

    @Override
    public int hashCode() {
        int hash = this.field.hashCode();
        hash = hash * 31 + this.vector.hashCode();
        return hash;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.vector.length) {
            int j = 0;
            while (j < this.field.getDegree()) {
                int r = j & 0x1F;
                int bitMask = 1 << r;
                int coeff = this.vector[i] & bitMask;
                if (coeff != 0) {
                    buf.append('1');
                } else {
                    buf.append('0');
                }
                ++j;
            }
            buf.append(' ');
            ++i;
        }
        return buf.toString();
    }
}

