/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.math.linearalgebra;

import com.donjin.org.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;

public final class BigEndianConversions {
    private BigEndianConversions() {
    }

    public static byte[] I2OSP(int x) {
        byte[] result = new byte[]{(byte)(x >>> 24), (byte)(x >>> 16), (byte)(x >>> 8), (byte)x};
        return result;
    }

    public static byte[] I2OSP(int x, int oLen) throws ArithmeticException {
        if (x < 0) {
            return null;
        }
        int octL = IntegerFunctions.ceilLog256(x);
        if (octL > oLen) {
            throw new ArithmeticException("Cannot encode given integer into specified number of octets.");
        }
        byte[] result = new byte[oLen];
        int i = oLen - 1;
        while (i >= oLen - octL) {
            result[i] = (byte)(x >>> 8 * (oLen - 1 - i));
            --i;
        }
        return result;
    }

    public static void I2OSP(int input, byte[] output, int outOff) {
        output[outOff++] = (byte)(input >>> 24);
        output[outOff++] = (byte)(input >>> 16);
        output[outOff++] = (byte)(input >>> 8);
        output[outOff] = (byte)input;
    }

    public static byte[] I2OSP(long input) {
        byte[] output = new byte[]{(byte)(input >>> 56), (byte)(input >>> 48), (byte)(input >>> 40), (byte)(input >>> 32), (byte)(input >>> 24), (byte)(input >>> 16), (byte)(input >>> 8), (byte)input};
        return output;
    }

    public static void I2OSP(long input, byte[] output, int outOff) {
        output[outOff++] = (byte)(input >>> 56);
        output[outOff++] = (byte)(input >>> 48);
        output[outOff++] = (byte)(input >>> 40);
        output[outOff++] = (byte)(input >>> 32);
        output[outOff++] = (byte)(input >>> 24);
        output[outOff++] = (byte)(input >>> 16);
        output[outOff++] = (byte)(input >>> 8);
        output[outOff] = (byte)input;
    }

    public static void I2OSP(int input, byte[] output, int outOff, int length) {
        int i = length - 1;
        while (i >= 0) {
            output[outOff + i] = (byte)(input >>> 8 * (length - 1 - i));
            --i;
        }
    }

    public static int OS2IP(byte[] input) {
        if (input.length > 4) {
            throw new ArithmeticException("invalid input length");
        }
        if (input.length == 0) {
            return 0;
        }
        int result = 0;
        int j = 0;
        while (j < input.length) {
            result |= (input[j] & 0xFF) << 8 * (input.length - 1 - j);
            ++j;
        }
        return result;
    }

    public static int OS2IP(byte[] input, int inOff) {
        int result = (input[inOff++] & 0xFF) << 24;
        result |= (input[inOff++] & 0xFF) << 16;
        result |= (input[inOff++] & 0xFF) << 8;
        return result |= input[inOff] & 0xFF;
    }

    public static int OS2IP(byte[] input, int inOff, int inLen) {
        if (input.length == 0 || input.length < inOff + inLen - 1) {
            return 0;
        }
        int result = 0;
        int j = 0;
        while (j < inLen) {
            result |= (input[inOff + j] & 0xFF) << 8 * (inLen - j - 1);
            ++j;
        }
        return result;
    }

    public static long OS2LIP(byte[] input, int inOff) {
        long result = ((long)input[inOff++] & 0xFFL) << 56;
        result |= ((long)input[inOff++] & 0xFFL) << 48;
        result |= ((long)input[inOff++] & 0xFFL) << 40;
        result |= ((long)input[inOff++] & 0xFFL) << 32;
        result |= ((long)input[inOff++] & 0xFFL) << 24;
        result |= (long)((input[inOff++] & 0xFF) << 16);
        result |= (long)((input[inOff++] & 0xFF) << 8);
        return result |= (long)(input[inOff] & 0xFF);
    }

    public static byte[] toByteArray(int[] input) {
        byte[] result = new byte[input.length << 2];
        int i = 0;
        while (i < input.length) {
            BigEndianConversions.I2OSP(input[i], result, i << 2);
            ++i;
        }
        return result;
    }

    public static byte[] toByteArray(int[] input, int length) {
        int intLen = input.length;
        byte[] result = new byte[length];
        int index = 0;
        int i = 0;
        while (i <= intLen - 2) {
            BigEndianConversions.I2OSP(input[i], result, index);
            ++i;
            index += 4;
        }
        BigEndianConversions.I2OSP(input[intLen - 1], result, index, length - index);
        return result;
    }

    public static int[] toIntArray(byte[] input) {
        int intLen = (input.length + 3) / 4;
        int lastLen = input.length & 3;
        int[] result = new int[intLen];
        int index = 0;
        int i = 0;
        while (i <= intLen - 2) {
            result[i] = BigEndianConversions.OS2IP(input, index);
            ++i;
            index += 4;
        }
        result[intLen - 1] = lastLen != 0 ? BigEndianConversions.OS2IP(input, index, lastLen) : BigEndianConversions.OS2IP(input, index);
        return result;
    }
}

