/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.jcajce.provider.sphincs;

import com.donjin.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.donjin.org.bouncycastle.asn1.ASN1OctetString;
import com.donjin.org.bouncycastle.asn1.DEROctetString;
import com.donjin.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.donjin.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.donjin.org.bouncycastle.crypto.CipherParameters;
import com.donjin.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.donjin.org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.donjin.org.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.donjin.org.bouncycastle.pqc.jcajce.interfaces.SPHINCSKey;
import com.donjin.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.PrivateKey;

public class BCSphincs256PrivateKey
implements PrivateKey,
SPHINCSKey {
    private static final long serialVersionUID = 1L;
    private final ASN1ObjectIdentifier treeDigest;
    private final SPHINCSPrivateKeyParameters params;

    public BCSphincs256PrivateKey(ASN1ObjectIdentifier treeDigest, SPHINCSPrivateKeyParameters params) {
        this.treeDigest = treeDigest;
        this.params = params;
    }

    public BCSphincs256PrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.treeDigest = SPHINCS256KeyParams.getInstance(keyInfo.getPrivateKeyAlgorithm().getParameters()).getTreeDigest().getAlgorithm();
        this.params = new SPHINCSPrivateKeyParameters(ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCSphincs256PrivateKey) {
            BCSphincs256PrivateKey otherKey = (BCSphincs256PrivateKey)o;
            return this.treeDigest.equals(otherKey.treeDigest) && Arrays.areEqual(this.params.getKeyData(), otherKey.params.getKeyData());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode(this.params.getKeyData());
    }

    @Override
    public final String getAlgorithm() {
        return "SPHINCS-256";
    }

    @Override
    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(new AlgorithmIdentifier(this.treeDigest)));
            PrivateKeyInfo pki = new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(this.params.getKeyData()));
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getKeyData() {
        return this.params.getKeyData();
    }

    CipherParameters getKeyParams() {
        return this.params;
    }
}

