/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.jcajce.provider.newhope;

import com.donjin.org.bouncycastle.asn1.ASN1OctetString;
import com.donjin.org.bouncycastle.asn1.DEROctetString;
import com.donjin.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.donjin.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.donjin.org.bouncycastle.crypto.CipherParameters;
import com.donjin.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.donjin.org.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import com.donjin.org.bouncycastle.pqc.jcajce.interfaces.NHPrivateKey;
import com.donjin.org.bouncycastle.util.Arrays;
import com.donjin.org.bouncycastle.util.Pack;
import java.io.IOException;

public class BCNHPrivateKey
implements NHPrivateKey {
    private static final long serialVersionUID = 1L;
    private final NHPrivateKeyParameters params;

    public BCNHPrivateKey(NHPrivateKeyParameters params) {
        this.params = params;
    }

    public BCNHPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.params = new NHPrivateKeyParameters(BCNHPrivateKey.convert(ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets()));
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BCNHPrivateKey)) {
            return false;
        }
        BCNHPrivateKey otherKey = (BCNHPrivateKey)o;
        return Arrays.areEqual(this.params.getSecData(), otherKey.params.getSecData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getSecData());
    }

    @Override
    public final String getAlgorithm() {
        return "NH";
    }

    @Override
    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            short[] privateKeyData = this.params.getSecData();
            byte[] octets = new byte[privateKeyData.length * 2];
            int i = 0;
            while (i != privateKeyData.length) {
                Pack.shortToLittleEndian(privateKeyData[i], octets, i * 2);
                ++i;
            }
            PrivateKeyInfo pki = new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(octets));
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public short[] getSecretData() {
        return this.params.getSecData();
    }

    CipherParameters getKeyParams() {
        return this.params;
    }

    private static short[] convert(byte[] octets) {
        short[] rv = new short[octets.length / 2];
        int i = 0;
        while (i != rv.length) {
            rv[i] = Pack.littleEndianToShort(octets, i * 2);
            ++i;
        }
        return rv;
    }
}

