/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.jcajce.provider.mceliece;

import com.donjin.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.donjin.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.donjin.org.bouncycastle.pqc.crypto.mceliece.McElieceKeyGenerationParameters;
import com.donjin.org.bouncycastle.pqc.crypto.mceliece.McElieceKeyPairGenerator;
import com.donjin.org.bouncycastle.pqc.crypto.mceliece.McElieceParameters;
import com.donjin.org.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import com.donjin.org.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import com.donjin.org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePrivateKey;
import com.donjin.org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePublicKey;
import com.donjin.org.bouncycastle.pqc.jcajce.spec.McElieceKeyGenParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class McElieceKeyPairGeneratorSpi
extends KeyPairGenerator {
    McElieceKeyPairGenerator kpg;

    public McElieceKeyPairGeneratorSpi() {
        super("McEliece");
    }

    @Override
    public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.kpg = new McElieceKeyPairGenerator();
        super.initialize(params);
        McElieceKeyGenParameterSpec ecc = (McElieceKeyGenParameterSpec)params;
        McElieceKeyGenerationParameters mccKGParams = new McElieceKeyGenerationParameters(CryptoServicesRegistrar.getSecureRandom(), new McElieceParameters(ecc.getM(), ecc.getT()));
        this.kpg.init(mccKGParams);
    }

    @Override
    public void initialize(int keySize, SecureRandom random) {
        McElieceKeyGenParameterSpec paramSpec = new McElieceKeyGenParameterSpec();
        try {
            this.initialize(paramSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        AsymmetricCipherKeyPair generateKeyPair = this.kpg.generateKeyPair();
        McEliecePrivateKeyParameters sk = (McEliecePrivateKeyParameters)generateKeyPair.getPrivate();
        McEliecePublicKeyParameters pk = (McEliecePublicKeyParameters)generateKeyPair.getPublic();
        return new KeyPair(new BCMcEliecePublicKey(pk), new BCMcEliecePrivateKey(sk));
    }
}

