/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.crypto.xmss;

import com.donjin.org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.donjin.org.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import com.donjin.org.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.donjin.org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.donjin.org.bouncycastle.util.Pack;

public final class XMSSSignature
extends XMSSReducedSignature
implements XMSSStoreableObjectInterface {
    private final int index;
    private final byte[] random;

    private XMSSSignature(Builder builder) {
        super(builder);
        this.index = builder.index;
        int n = this.getParams().getDigestSize();
        byte[] tmpRandom = builder.random;
        if (tmpRandom != null) {
            if (tmpRandom.length != n) {
                throw new IllegalArgumentException("size of random needs to be equal to size of digest");
            }
            this.random = tmpRandom;
        } else {
            this.random = new byte[n];
        }
    }

    @Override
    public byte[] toByteArray() {
        int n = this.getParams().getDigestSize();
        int indexSize = 4;
        int randomSize = n;
        int signatureSize = this.getParams().getWOTSPlus().getParams().getLen() * n;
        int authPathSize = this.getParams().getHeight() * n;
        int totalSize = indexSize + randomSize + signatureSize + authPathSize;
        byte[] out = new byte[totalSize];
        int position = 0;
        Pack.intToBigEndian(this.index, out, position);
        XMSSUtil.copyBytesAtOffset(out, this.random, position += indexSize);
        position += randomSize;
        byte[][] signature = this.getWOTSPlusSignature().toByteArray();
        int i = 0;
        while (i < signature.length) {
            XMSSUtil.copyBytesAtOffset(out, signature[i], position);
            position += n;
            ++i;
        }
        i = 0;
        while (i < this.getAuthPath().size()) {
            byte[] value = this.getAuthPath().get(i).getValue();
            XMSSUtil.copyBytesAtOffset(out, value, position);
            position += n;
            ++i;
        }
        return out;
    }

    public int getIndex() {
        return this.index;
    }

    public byte[] getRandom() {
        return XMSSUtil.cloneArray(this.random);
    }

    /* synthetic */ XMSSSignature(Builder builder, XMSSSignature xMSSSignature) {
        this(builder);
    }

    public static class Builder
    extends XMSSReducedSignature.Builder {
        private final XMSSParameters params;
        private int index = 0;
        private byte[] random = null;

        public Builder(XMSSParameters params) {
            super(params);
            this.params = params;
        }

        public Builder withIndex(int val) {
            this.index = val;
            return this;
        }

        public Builder withRandom(byte[] val) {
            this.random = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withSignature(byte[] val) {
            if (val == null) {
                throw new NullPointerException("signature == null");
            }
            int n = this.params.getDigestSize();
            int len = this.params.getWOTSPlus().getParams().getLen();
            int height = this.params.getHeight();
            int indexSize = 4;
            int randomSize = n;
            int signatureSize = len * n;
            int authPathSize = height * n;
            int position = 0;
            this.index = Pack.bigEndianToInt(val, position);
            this.random = XMSSUtil.extractBytesAtOffset(val, position += indexSize, randomSize);
            this.withReducedSignature(XMSSUtil.extractBytesAtOffset(val, position += randomSize, signatureSize + authPathSize));
            return this;
        }

        @Override
        public XMSSSignature build() {
            return new XMSSSignature(this, null);
        }
    }
}

