/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.crypto.xmss;

import com.donjin.org.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import com.donjin.org.bouncycastle.util.Pack;

final class LTreeAddress
extends XMSSAddress {
    private static final int TYPE = 1;
    private final int lTreeAddress;
    private final int treeHeight;
    private final int treeIndex;

    private LTreeAddress(Builder builder) {
        super(builder);
        this.lTreeAddress = builder.lTreeAddress;
        this.treeHeight = builder.treeHeight;
        this.treeIndex = builder.treeIndex;
    }

    @Override
    protected byte[] toByteArray() {
        byte[] byteRepresentation = super.toByteArray();
        Pack.intToBigEndian(this.lTreeAddress, byteRepresentation, 16);
        Pack.intToBigEndian(this.treeHeight, byteRepresentation, 20);
        Pack.intToBigEndian(this.treeIndex, byteRepresentation, 24);
        return byteRepresentation;
    }

    protected int getLTreeAddress() {
        return this.lTreeAddress;
    }

    protected int getTreeHeight() {
        return this.treeHeight;
    }

    protected int getTreeIndex() {
        return this.treeIndex;
    }

    /* synthetic */ LTreeAddress(Builder builder, LTreeAddress lTreeAddress) {
        this(builder);
    }

    protected static class Builder
    extends XMSSAddress.Builder<Builder> {
        private int lTreeAddress = 0;
        private int treeHeight = 0;
        private int treeIndex = 0;

        protected Builder() {
            super(1);
        }

        protected Builder withLTreeAddress(int val) {
            this.lTreeAddress = val;
            return this;
        }

        protected Builder withTreeHeight(int val) {
            this.treeHeight = val;
            return this;
        }

        protected Builder withTreeIndex(int val) {
            this.treeIndex = val;
            return this;
        }

        @Override
        protected XMSSAddress build() {
            return new LTreeAddress(this, null);
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

