/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.crypto.sphincs;

import com.donjin.org.bouncycastle.pqc.crypto.sphincs.HashFunctions;
import com.donjin.org.bouncycastle.pqc.crypto.sphincs.Seed;

class Horst {
    static final int HORST_LOGT = 16;
    static final int HORST_T = 65536;
    static final int HORST_K = 32;
    static final int HORST_SKBYTES = 32;
    static final int HORST_SIGBYTES = 13312;
    static final int N_MASKS = 32;

    Horst() {
    }

    static void expand_seed(byte[] outseeds, byte[] inseed) {
        Seed.prg(outseeds, 0, 0x200000L, inseed, 0);
    }

    static int horst_sign(HashFunctions hs, byte[] sig, int sigOff, byte[] pk, byte[] seed, byte[] masks, byte[] m_hash) {
        int j;
        byte[] sk = new byte[0x200000];
        int sigpos = sigOff;
        byte[] tree = new byte[4194272];
        Horst.expand_seed(sk, seed);
        int i = 0;
        while (i < 65536) {
            hs.hash_n_n(tree, (65535 + i) * 32, sk, i * 32);
            ++i;
        }
        i = 0;
        while (i < 16) {
            long offset_in = (1 << 16 - i) - 1;
            long offset_out = (1 << 16 - i - 1) - 1;
            j = 0;
            while (j < 1 << 16 - i - 1) {
                hs.hash_2n_n_mask(tree, (int)((offset_out + (long)j) * 32L), tree, (int)((offset_in + (long)(2 * j)) * 32L), masks, 2 * i * 32);
                ++j;
            }
            ++i;
        }
        j = 2016;
        while (j < 4064) {
            sig[sigpos++] = tree[j];
            ++j;
        }
        i = 0;
        while (i < 32) {
            int idx = (m_hash[2 * i] & 0xFF) + ((m_hash[2 * i + 1] & 0xFF) << 8);
            int k = 0;
            while (k < 32) {
                sig[sigpos++] = sk[idx * 32 + k];
                ++k;
            }
            idx += 65535;
            j = 0;
            while (j < 10) {
                idx = (idx & 1) != 0 ? idx + 1 : idx - 1;
                k = 0;
                while (k < 32) {
                    sig[sigpos++] = tree[idx * 32 + k];
                    ++k;
                }
                idx = (idx - 1) / 2;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 32) {
            pk[i] = tree[i];
            ++i;
        }
        return 13312;
    }

    static int horst_verify(HashFunctions hs, byte[] pk, byte[] sig, int sigOff, byte[] masks, byte[] m_hash) {
        int j;
        byte[] buffer = new byte[1024];
        int sigOffset = sigOff + 2048;
        int i = 0;
        while (i < 32) {
            int k;
            int idx = (m_hash[2 * i] & 0xFF) + ((m_hash[2 * i + 1] & 0xFF) << 8);
            if ((idx & 1) == 0) {
                hs.hash_n_n(buffer, 0, sig, sigOffset);
                k = 0;
                while (k < 32) {
                    buffer[32 + k] = sig[sigOffset + 32 + k];
                    ++k;
                }
            } else {
                hs.hash_n_n(buffer, 32, sig, sigOffset);
                k = 0;
                while (k < 32) {
                    buffer[k] = sig[sigOffset + 32 + k];
                    ++k;
                }
            }
            sigOffset += 64;
            j = 1;
            while (j < 10) {
                if (((idx >>>= 1) & 1) == 0) {
                    hs.hash_2n_n_mask(buffer, 0, buffer, 0, masks, 2 * (j - 1) * 32);
                    k = 0;
                    while (k < 32) {
                        buffer[32 + k] = sig[sigOffset + k];
                        ++k;
                    }
                } else {
                    hs.hash_2n_n_mask(buffer, 32, buffer, 0, masks, 2 * (j - 1) * 32);
                    k = 0;
                    while (k < 32) {
                        buffer[k] = sig[sigOffset + k];
                        ++k;
                    }
                }
                sigOffset += 32;
                ++j;
            }
            idx >>>= 1;
            hs.hash_2n_n_mask(buffer, 0, buffer, 0, masks, 576);
            k = 0;
            while (k < 32) {
                if (sig[sigOff + idx * 32 + k] != buffer[k]) {
                    k = 0;
                    while (k < 32) {
                        pk[k] = 0;
                        ++k;
                    }
                    return -1;
                }
                ++k;
            }
            ++i;
        }
        j = 0;
        while (j < 32) {
            hs.hash_2n_n_mask(buffer, j * 32, sig, sigOff + 2 * j * 32, masks, 640);
            ++j;
        }
        j = 0;
        while (j < 16) {
            hs.hash_2n_n_mask(buffer, j * 32, buffer, 2 * j * 32, masks, 704);
            ++j;
        }
        j = 0;
        while (j < 8) {
            hs.hash_2n_n_mask(buffer, j * 32, buffer, 2 * j * 32, masks, 768);
            ++j;
        }
        j = 0;
        while (j < 4) {
            hs.hash_2n_n_mask(buffer, j * 32, buffer, 2 * j * 32, masks, 832);
            ++j;
        }
        j = 0;
        while (j < 2) {
            hs.hash_2n_n_mask(buffer, j * 32, buffer, 2 * j * 32, masks, 896);
            ++j;
        }
        hs.hash_2n_n_mask(pk, 0, buffer, 0, masks, 960);
        return 0;
    }
}

