/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.crypto.sphincs;

import com.donjin.org.bouncycastle.crypto.Digest;
import com.donjin.org.bouncycastle.pqc.crypto.sphincs.Permute;
import com.donjin.org.bouncycastle.util.Strings;

class HashFunctions {
    private static final byte[] hashc = Strings.toByteArray("expand 32-byte to 64-byte state!");
    private final Digest dig256;
    private final Digest dig512;
    private final Permute perm = new Permute();

    HashFunctions(Digest dig256) {
        this(dig256, null);
    }

    HashFunctions(Digest dig256, Digest dig512) {
        this.dig256 = dig256;
        this.dig512 = dig512;
    }

    int varlen_hash(byte[] out, int outOff, byte[] in, int inLen) {
        this.dig256.update(in, 0, inLen);
        this.dig256.doFinal(out, outOff);
        return 0;
    }

    Digest getMessageHash() {
        return this.dig512;
    }

    int hash_2n_n(byte[] out, int outOff, byte[] in, int inOff) {
        byte[] x = new byte[64];
        int i = 0;
        while (i < 32) {
            x[i] = in[inOff + i];
            x[i + 32] = hashc[i];
            ++i;
        }
        this.perm.chacha_permute(x, x);
        i = 0;
        while (i < 32) {
            x[i] = (byte)(x[i] ^ in[inOff + i + 32]);
            ++i;
        }
        this.perm.chacha_permute(x, x);
        i = 0;
        while (i < 32) {
            out[outOff + i] = x[i];
            ++i;
        }
        return 0;
    }

    int hash_2n_n_mask(byte[] out, int outOff, byte[] in, int inOff, byte[] mask, int maskOff) {
        byte[] buf = new byte[64];
        int i = 0;
        while (i < 64) {
            buf[i] = (byte)(in[inOff + i] ^ mask[maskOff + i]);
            ++i;
        }
        int rv = this.hash_2n_n(out, outOff, buf, 0);
        return rv;
    }

    int hash_n_n(byte[] out, int outOff, byte[] in, int inOff) {
        byte[] x = new byte[64];
        int i = 0;
        while (i < 32) {
            x[i] = in[inOff + i];
            x[i + 32] = hashc[i];
            ++i;
        }
        this.perm.chacha_permute(x, x);
        i = 0;
        while (i < 32) {
            out[outOff + i] = x[i];
            ++i;
        }
        return 0;
    }

    int hash_n_n_mask(byte[] out, int outOff, byte[] in, int inOff, byte[] mask, int maskOff) {
        byte[] buf = new byte[32];
        int i = 0;
        while (i < 32) {
            buf[i] = (byte)(in[inOff + i] ^ mask[maskOff + i]);
            ++i;
        }
        return this.hash_n_n(out, outOff, buf, 0);
    }
}

