/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.crypto.ntru;

import com.donjin.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.donjin.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.donjin.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.donjin.org.bouncycastle.crypto.KeyGenerationParameters;
import com.donjin.org.bouncycastle.pqc.crypto.ntru.NTRUSigningKeyGenerationParameters;
import com.donjin.org.bouncycastle.pqc.crypto.ntru.NTRUSigningPrivateKeyParameters;
import com.donjin.org.bouncycastle.pqc.crypto.ntru.NTRUSigningPublicKeyParameters;
import com.donjin.org.bouncycastle.pqc.math.ntru.euclid.BigIntEuclidean;
import com.donjin.org.bouncycastle.pqc.math.ntru.polynomial.BigDecimalPolynomial;
import com.donjin.org.bouncycastle.pqc.math.ntru.polynomial.BigIntPolynomial;
import com.donjin.org.bouncycastle.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import com.donjin.org.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.donjin.org.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import com.donjin.org.bouncycastle.pqc.math.ntru.polynomial.ProductFormPolynomial;
import com.donjin.org.bouncycastle.pqc.math.ntru.polynomial.Resultant;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NTRUSigningKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private NTRUSigningKeyGenerationParameters params;

    @Override
    public void init(KeyGenerationParameters param) {
        this.params = (NTRUSigningKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        NTRUSigningPublicKeyParameters pub = null;
        ExecutorService executor = Executors.newCachedThreadPool();
        ArrayList<Future<NTRUSigningPrivateKeyParameters.Basis>> bases = new ArrayList<Future<NTRUSigningPrivateKeyParameters.Basis>>();
        int k = this.params.B;
        while (k >= 0) {
            bases.add(executor.submit(new BasisGenerationTask()));
            --k;
        }
        executor.shutdown();
        ArrayList<NTRUSigningPrivateKeyParameters.Basis> basises = new ArrayList<NTRUSigningPrivateKeyParameters.Basis>();
        int k2 = this.params.B;
        while (k2 >= 0) {
            Future basis = (Future)bases.get(k2);
            try {
                basises.add((NTRUSigningPrivateKeyParameters.Basis)basis.get());
                if (k2 == this.params.B) {
                    pub = new NTRUSigningPublicKeyParameters(((NTRUSigningPrivateKeyParameters.Basis)basis.get()).h, this.params.getSigningParameters());
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            --k2;
        }
        NTRUSigningPrivateKeyParameters priv = new NTRUSigningPrivateKeyParameters(basises, pub);
        AsymmetricCipherKeyPair kp = new AsymmetricCipherKeyPair(pub, priv);
        return kp;
    }

    public AsymmetricCipherKeyPair generateKeyPairSingleThread() {
        ArrayList<NTRUSigningPrivateKeyParameters.Basis> basises = new ArrayList<NTRUSigningPrivateKeyParameters.Basis>();
        NTRUSigningPublicKeyParameters pub = null;
        int k = this.params.B;
        while (k >= 0) {
            NTRUSigningPrivateKeyParameters.Basis basis = this.generateBoundedBasis();
            basises.add(basis);
            if (k == 0) {
                pub = new NTRUSigningPublicKeyParameters(basis.h, this.params.getSigningParameters());
            }
            --k;
        }
        NTRUSigningPrivateKeyParameters priv = new NTRUSigningPrivateKeyParameters(basises, pub);
        return new AsymmetricCipherKeyPair(pub, priv);
    }

    private void minimizeFG(IntegerPolynomial f, IntegerPolynomial g, IntegerPolynomial F, IntegerPolynomial G, int N) {
        int E = 0;
        int j = 0;
        while (j < N) {
            E += 2 * N * (f.coeffs[j] * f.coeffs[j] + g.coeffs[j] * g.coeffs[j]);
            ++j;
        }
        E -= 4;
        IntegerPolynomial u = (IntegerPolynomial)f.clone();
        IntegerPolynomial v = (IntegerPolynomial)g.clone();
        int j2 = 0;
        int k = 0;
        int maxAdjustment = N;
        while (k < maxAdjustment && j2 < N) {
            int D1;
            int D = 0;
            int i = 0;
            while (i < N) {
                D1 = F.coeffs[i] * f.coeffs[i];
                int D2 = G.coeffs[i] * g.coeffs[i];
                int D3 = 4 * N * (D1 + D2);
                D += D3;
                ++i;
            }
            D1 = 4 * (F.sumCoeffs() + G.sumCoeffs());
            if ((D -= D1) > E) {
                F.sub(u);
                G.sub(v);
                ++k;
                j2 = 0;
            } else if (D < -E) {
                F.add(u);
                G.add(v);
                ++k;
                j2 = 0;
            }
            ++j2;
            u.rotate1();
            v.rotate1();
        }
    }

    private FGBasis generateBasis() {
        IntegerPolynomial h;
        IntegerPolynomial fPrime;
        BigIntPolynomial C;
        BigIntEuclidean r;
        Resultant rg;
        IntegerPolynomial gInt;
        DenseTernaryPolynomial g;
        DenseTernaryPolynomial f;
        IntegerPolynomial fq;
        IntegerPolynomial fInt;
        int N = this.params.N;
        int q = this.params.q;
        int d = this.params.d;
        int d1 = this.params.d1;
        int d2 = this.params.d2;
        int d3 = this.params.d3;
        int basisType = this.params.basisType;
        int _2n1 = 2 * N + 1;
        boolean primeCheck = this.params.primeCheck;
        do {
            f = this.params.polyType == 0 ? DenseTernaryPolynomial.generateRandom(N, d + 1, d, CryptoServicesRegistrar.getSecureRandom()) : ProductFormPolynomial.generateRandom(N, d1, d2, d3 + 1, d3, CryptoServicesRegistrar.getSecureRandom());
            fInt = f.toIntegerPolynomial();
        } while (primeCheck && fInt.resultant((int)_2n1).res.equals(BigInteger.ZERO) || (fq = fInt.invertFq(q)) == null);
        Resultant rf = fInt.resultant();
        while (true) {
            g = this.params.polyType == 0 ? DenseTernaryPolynomial.generateRandom(N, d + 1, d, CryptoServicesRegistrar.getSecureRandom()) : ProductFormPolynomial.generateRandom(N, d1, d2, d3 + 1, d3, CryptoServicesRegistrar.getSecureRandom());
            gInt = g.toIntegerPolynomial();
            if (primeCheck && gInt.resultant((int)_2n1).res.equals(BigInteger.ZERO) || gInt.invertFq(q) == null) continue;
            rg = gInt.resultant();
            r = BigIntEuclidean.calculate(rf.res, rg.res);
            if (r.gcd.equals(BigInteger.ONE)) break;
        }
        BigIntPolynomial A = (BigIntPolynomial)rf.rho.clone();
        A.mult(r.x.multiply(BigInteger.valueOf(q)));
        BigIntPolynomial B = (BigIntPolynomial)rg.rho.clone();
        B.mult(r.y.multiply(BigInteger.valueOf(-q)));
        if (this.params.keyGenAlg == 0) {
            int[] fRevCoeffs = new int[N];
            int[] gRevCoeffs = new int[N];
            fRevCoeffs[0] = fInt.coeffs[0];
            gRevCoeffs[0] = gInt.coeffs[0];
            int i = 1;
            while (i < N) {
                fRevCoeffs[i] = fInt.coeffs[N - i];
                gRevCoeffs[i] = gInt.coeffs[N - i];
                ++i;
            }
            IntegerPolynomial fRev = new IntegerPolynomial(fRevCoeffs);
            IntegerPolynomial gRev = new IntegerPolynomial(gRevCoeffs);
            IntegerPolynomial t = f.mult(fRev);
            t.add(g.mult(gRev));
            Resultant rt = t.resultant();
            C = fRev.mult(B);
            C.add(gRev.mult(A));
            C = C.mult(rt.rho);
            C.div(rt.res);
        } else {
            int log10N = 0;
            int i = 1;
            while (i < N) {
                ++log10N;
                i *= 10;
            }
            BigDecimalPolynomial fInv = rf.rho.div(new BigDecimal(rf.res), B.getMaxCoeffLength() + 1 + log10N);
            BigDecimalPolynomial gInv = rg.rho.div(new BigDecimal(rg.res), A.getMaxCoeffLength() + 1 + log10N);
            BigDecimalPolynomial Cdec = fInv.mult(B);
            Cdec.add(gInv.mult(A));
            Cdec.halve();
            C = Cdec.round();
        }
        BigIntPolynomial F = (BigIntPolynomial)B.clone();
        F.sub(f.mult(C));
        BigIntPolynomial G = (BigIntPolynomial)A.clone();
        G.sub(g.mult(C));
        IntegerPolynomial FInt = new IntegerPolynomial(F);
        IntegerPolynomial GInt = new IntegerPolynomial(G);
        this.minimizeFG(fInt, gInt, FInt, GInt, N);
        if (basisType == 0) {
            fPrime = FInt;
            h = g.mult(fq, q);
        } else {
            fPrime = g;
            h = FInt.mult(fq, q);
        }
        h.modPositive(q);
        return new FGBasis(f, fPrime, h, FInt, GInt, this.params);
    }

    public NTRUSigningPrivateKeyParameters.Basis generateBoundedBasis() {
        FGBasis basis;
        while (!(basis = this.generateBasis()).isNormOk()) {
        }
        return basis;
    }

    private class BasisGenerationTask
    implements Callable<NTRUSigningPrivateKeyParameters.Basis> {
        private BasisGenerationTask() {
        }

        @Override
        public NTRUSigningPrivateKeyParameters.Basis call() throws Exception {
            return NTRUSigningKeyPairGenerator.this.generateBoundedBasis();
        }
    }

    public class FGBasis
    extends NTRUSigningPrivateKeyParameters.Basis {
        public IntegerPolynomial F;
        public IntegerPolynomial G;

        FGBasis(Polynomial f, Polynomial fPrime, IntegerPolynomial h, IntegerPolynomial F, IntegerPolynomial G, NTRUSigningKeyGenerationParameters params) {
            super(f, fPrime, h, params);
            this.F = F;
            this.G = G;
        }

        boolean isNormOk() {
            double keyNormBoundSq = this.params.keyNormBoundSq;
            int q = this.params.q;
            return (double)this.F.centeredNormSq(q) < keyNormBoundSq && (double)this.G.centeredNormSq(q) < keyNormBoundSq;
        }
    }
}

