/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.crypto.mceliece;

import com.donjin.org.bouncycastle.crypto.CipherParameters;
import com.donjin.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.donjin.org.bouncycastle.crypto.Digest;
import com.donjin.org.bouncycastle.crypto.InvalidCipherTextException;
import com.donjin.org.bouncycastle.crypto.digests.SHA1Digest;
import com.donjin.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.donjin.org.bouncycastle.crypto.prng.DigestRandomGenerator;
import com.donjin.org.bouncycastle.pqc.crypto.MessageEncryptor;
import com.donjin.org.bouncycastle.pqc.crypto.mceliece.Conversions;
import com.donjin.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import com.donjin.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Primitives;
import com.donjin.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.donjin.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.donjin.org.bouncycastle.pqc.crypto.mceliece.Utils;
import com.donjin.org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import com.donjin.org.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import java.security.SecureRandom;

public class McElieceFujisakiCipher
implements MessageEncryptor {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2.1";
    private static final String DEFAULT_PRNG_NAME = "SHA1PRNG";
    private Digest messDigest;
    private SecureRandom sr;
    private int n;
    private int k;
    private int t;
    McElieceCCA2KeyParameters key;
    private boolean forEncryption;

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        this.forEncryption = forEncryption;
        if (forEncryption) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.sr = rParam.getRandom();
                this.key = (McElieceCCA2PublicKeyParameters)rParam.getParameters();
                this.initCipherEncrypt((McElieceCCA2PublicKeyParameters)this.key);
            } else {
                this.sr = CryptoServicesRegistrar.getSecureRandom();
                this.key = (McElieceCCA2PublicKeyParameters)param;
                this.initCipherEncrypt((McElieceCCA2PublicKeyParameters)this.key);
            }
        } else {
            this.key = (McElieceCCA2PrivateKeyParameters)param;
            this.initCipherDecrypt((McElieceCCA2PrivateKeyParameters)this.key);
        }
    }

    public int getKeySize(McElieceCCA2KeyParameters key) throws IllegalArgumentException {
        if (key instanceof McElieceCCA2PublicKeyParameters) {
            return ((McElieceCCA2PublicKeyParameters)key).getN();
        }
        if (key instanceof McElieceCCA2PrivateKeyParameters) {
            return ((McElieceCCA2PrivateKeyParameters)key).getN();
        }
        throw new IllegalArgumentException("unsupported type");
    }

    private void initCipherEncrypt(McElieceCCA2PublicKeyParameters pubKey) {
        this.sr = this.sr != null ? this.sr : CryptoServicesRegistrar.getSecureRandom();
        this.messDigest = Utils.getDigest(pubKey.getDigest());
        this.n = pubKey.getN();
        this.k = pubKey.getK();
        this.t = pubKey.getT();
    }

    private void initCipherDecrypt(McElieceCCA2PrivateKeyParameters privKey) {
        this.messDigest = Utils.getDigest(privKey.getDigest());
        this.n = privKey.getN();
        this.t = privKey.getT();
    }

    @Override
    public byte[] messageEncrypt(byte[] input) {
        if (!this.forEncryption) {
            throw new IllegalStateException("cipher initialised for decryption");
        }
        GF2Vector r = new GF2Vector(this.k, this.sr);
        byte[] rBytes = r.getEncoded();
        byte[] rm = ByteUtils.concatenate(rBytes, input);
        this.messDigest.update(rm, 0, rm.length);
        byte[] hrm = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(hrm, 0);
        GF2Vector z = Conversions.encode(this.n, this.t, hrm);
        byte[] c1 = McElieceCCA2Primitives.encryptionPrimitive((McElieceCCA2PublicKeyParameters)this.key, r, z).getEncoded();
        DigestRandomGenerator sr0 = new DigestRandomGenerator(new SHA1Digest());
        sr0.addSeedMaterial(rBytes);
        byte[] c2 = new byte[input.length];
        sr0.nextBytes(c2);
        int i = 0;
        while (i < input.length) {
            int n = i;
            c2[n] = (byte)(c2[n] ^ input[i]);
            ++i;
        }
        return ByteUtils.concatenate(c1, c2);
    }

    @Override
    public byte[] messageDecrypt(byte[] input) throws InvalidCipherTextException {
        if (this.forEncryption) {
            throw new IllegalStateException("cipher initialised for decryption");
        }
        int c1Len = this.n + 7 >> 3;
        int c2Len = input.length - c1Len;
        byte[][] c1c2 = ByteUtils.split(input, c1Len);
        byte[] c1 = c1c2[0];
        byte[] c2 = c1c2[1];
        GF2Vector hrmVec = GF2Vector.OS2VP(this.n, c1);
        GF2Vector[] decC1 = McElieceCCA2Primitives.decryptionPrimitive((McElieceCCA2PrivateKeyParameters)this.key, hrmVec);
        byte[] rBytes = decC1[0].getEncoded();
        GF2Vector z = decC1[1];
        DigestRandomGenerator sr0 = new DigestRandomGenerator(new SHA1Digest());
        sr0.addSeedMaterial(rBytes);
        byte[] mBytes = new byte[c2Len];
        sr0.nextBytes(mBytes);
        int i = 0;
        while (i < c2Len) {
            int n = i;
            mBytes[n] = (byte)(mBytes[n] ^ c2[i]);
            ++i;
        }
        byte[] rmBytes = ByteUtils.concatenate(rBytes, mBytes);
        byte[] hrm = new byte[this.messDigest.getDigestSize()];
        this.messDigest.update(rmBytes, 0, rmBytes.length);
        this.messDigest.doFinal(hrm, 0);
        hrmVec = Conversions.encode(this.n, this.t, hrm);
        if (!hrmVec.equals(z)) {
            throw new InvalidCipherTextException("Bad Padding: invalid ciphertext");
        }
        return mBytes;
    }
}

