/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.crypto.gmss.util;

import com.donjin.org.bouncycastle.crypto.Digest;
import com.donjin.org.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;

public class WinternitzOTSignature {
    private Digest messDigestOTS;
    private int mdsize;
    private int keysize;
    private byte[][] privateKeyOTS;
    private int w;
    private GMSSRandom gmssRandom;
    private int messagesize;
    private int checksumsize;

    public WinternitzOTSignature(byte[] seed0, Digest digest, int w) {
        this.w = w;
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(this.messDigestOTS);
        this.mdsize = this.messDigestOTS.getDigestSize();
        int mdsizeBit = this.mdsize << 3;
        this.messagesize = (int)Math.ceil((double)mdsizeBit / (double)w);
        this.checksumsize = this.getLog((this.messagesize << w) + 1);
        this.keysize = this.messagesize + (int)Math.ceil((double)this.checksumsize / (double)w);
        this.privateKeyOTS = new byte[this.keysize][this.mdsize];
        byte[] dummy = new byte[this.mdsize];
        System.arraycopy(seed0, 0, dummy, 0, dummy.length);
        int i = 0;
        while (i < this.keysize) {
            this.privateKeyOTS[i] = this.gmssRandom.nextSeed(dummy);
            ++i;
        }
    }

    public byte[][] getPrivateKey() {
        return this.privateKeyOTS;
    }

    public byte[] getPublicKey() {
        byte[] helppubKey = new byte[this.keysize * this.mdsize];
        byte[] help = new byte[this.mdsize];
        int two_power_t = 1 << this.w;
        int i = 0;
        while (i < this.keysize) {
            this.messDigestOTS.update(this.privateKeyOTS[i], 0, this.privateKeyOTS[i].length);
            help = new byte[this.messDigestOTS.getDigestSize()];
            this.messDigestOTS.doFinal(help, 0);
            int j = 2;
            while (j < two_power_t) {
                this.messDigestOTS.update(help, 0, help.length);
                help = new byte[this.messDigestOTS.getDigestSize()];
                this.messDigestOTS.doFinal(help, 0);
                ++j;
            }
            System.arraycopy(help, 0, helppubKey, this.mdsize * i, this.mdsize);
            ++i;
        }
        this.messDigestOTS.update(helppubKey, 0, helppubKey.length);
        byte[] tmp = new byte[this.messDigestOTS.getDigestSize()];
        this.messDigestOTS.doFinal(tmp, 0);
        return tmp;
    }

    public byte[] getSignature(byte[] message) {
        byte[] sign;
        block23: {
            long test8;
            int j;
            int ii;
            long big8;
            int rest;
            int s;
            int c;
            int counter;
            byte[] hash;
            block24: {
                long big82;
                int test;
                block22: {
                    sign = new byte[this.keysize * this.mdsize];
                    hash = new byte[this.mdsize];
                    counter = 0;
                    c = 0;
                    test = 0;
                    this.messDigestOTS.update(message, 0, message.length);
                    hash = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hash, 0);
                    if (8 % this.w != 0) break block22;
                    int d = 8 / this.w;
                    int k = (1 << this.w) - 1;
                    byte[] hlp = new byte[this.mdsize];
                    int i = 0;
                    while (i < hash.length) {
                        int j2 = 0;
                        while (j2 < d) {
                            test = hash[i] & k;
                            c += test;
                            System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                            while (test > 0) {
                                this.messDigestOTS.update(hlp, 0, hlp.length);
                                hlp = new byte[this.messDigestOTS.getDigestSize()];
                                this.messDigestOTS.doFinal(hlp, 0);
                                --test;
                            }
                            System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                            hash[i] = (byte)(hash[i] >>> this.w);
                            ++counter;
                            ++j2;
                        }
                        ++i;
                    }
                    c = (this.messagesize << this.w) - c;
                    i = 0;
                    while (i < this.checksumsize) {
                        test = c & k;
                        System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                        while (test > 0) {
                            this.messDigestOTS.update(hlp, 0, hlp.length);
                            hlp = new byte[this.messDigestOTS.getDigestSize()];
                            this.messDigestOTS.doFinal(hlp, 0);
                            --test;
                        }
                        System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                        c >>>= this.w;
                        ++counter;
                        i += this.w;
                    }
                    break block23;
                }
                if (this.w >= 8) break block24;
                int d = this.mdsize / this.w;
                int k = (1 << this.w) - 1;
                byte[] hlp = new byte[this.mdsize];
                int ii2 = 0;
                int i = 0;
                while (i < d) {
                    big82 = 0L;
                    int j3 = 0;
                    while (j3 < this.w) {
                        big82 ^= (long)((hash[ii2] & 0xFF) << (j3 << 3));
                        ++ii2;
                        ++j3;
                    }
                    j3 = 0;
                    while (j3 < 8) {
                        test = (int)(big82 & (long)k);
                        c += test;
                        System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                        while (test > 0) {
                            this.messDigestOTS.update(hlp, 0, hlp.length);
                            hlp = new byte[this.messDigestOTS.getDigestSize()];
                            this.messDigestOTS.doFinal(hlp, 0);
                            --test;
                        }
                        System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                        big82 >>>= this.w;
                        ++counter;
                        ++j3;
                    }
                    ++i;
                }
                d = this.mdsize % this.w;
                big82 = 0L;
                int j4 = 0;
                while (j4 < d) {
                    big82 ^= (long)((hash[ii2] & 0xFF) << (j4 << 3));
                    ++ii2;
                    ++j4;
                }
                d <<= 3;
                j4 = 0;
                while (j4 < d) {
                    test = (int)(big82 & (long)k);
                    c += test;
                    System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                    while (test > 0) {
                        this.messDigestOTS.update(hlp, 0, hlp.length);
                        hlp = new byte[this.messDigestOTS.getDigestSize()];
                        this.messDigestOTS.doFinal(hlp, 0);
                        --test;
                    }
                    System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                    big82 >>>= this.w;
                    ++counter;
                    j4 += this.w;
                }
                c = (this.messagesize << this.w) - c;
                i = 0;
                while (i < this.checksumsize) {
                    test = c & k;
                    System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                    while (test > 0) {
                        this.messDigestOTS.update(hlp, 0, hlp.length);
                        hlp = new byte[this.messDigestOTS.getDigestSize()];
                        this.messDigestOTS.doFinal(hlp, 0);
                        --test;
                    }
                    System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                    c >>>= this.w;
                    ++counter;
                    i += this.w;
                }
                break block23;
            }
            if (this.w >= 57) break block23;
            int d = (this.mdsize << 3) - this.w;
            int k = (1 << this.w) - 1;
            byte[] hlp = new byte[this.mdsize];
            int r = 0;
            while (r <= d) {
                s = r >>> 3;
                rest = r % 8;
                int f = (r += this.w) + 7 >>> 3;
                big8 = 0L;
                ii = 0;
                j = s;
                while (j < f) {
                    big8 ^= (long)((hash[j] & 0xFF) << (ii << 3));
                    ++ii;
                    ++j;
                }
                test8 = (big8 >>>= rest) & (long)k;
                c = (int)((long)c + test8);
                System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                while (test8 > 0L) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                    --test8;
                }
                System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                ++counter;
            }
            s = r >>> 3;
            if (s < this.mdsize) {
                rest = r % 8;
                big8 = 0L;
                ii = 0;
                j = s;
                while (j < this.mdsize) {
                    big8 ^= (long)((hash[j] & 0xFF) << (ii << 3));
                    ++ii;
                    ++j;
                }
                test8 = (big8 >>>= rest) & (long)k;
                c = (int)((long)c + test8);
                System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                while (test8 > 0L) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                    --test8;
                }
                System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                ++counter;
            }
            c = (this.messagesize << this.w) - c;
            int i = 0;
            while (i < this.checksumsize) {
                test8 = c & k;
                System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                while (test8 > 0L) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                    --test8;
                }
                System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                c >>>= this.w;
                ++counter;
                i += this.w;
            }
        }
        return sign;
    }

    public int getLog(int intValue) {
        int log = 1;
        int i = 2;
        while (i < intValue) {
            i <<= 1;
            ++log;
        }
        return log;
    }
}

