/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.crypto.gmss;

import com.donjin.org.bouncycastle.crypto.Digest;
import com.donjin.org.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import com.donjin.org.bouncycastle.pqc.crypto.gmss.GMSSKeyParameters;
import com.donjin.org.bouncycastle.pqc.crypto.gmss.GMSSLeaf;
import com.donjin.org.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import com.donjin.org.bouncycastle.pqc.crypto.gmss.GMSSRootCalc;
import com.donjin.org.bouncycastle.pqc.crypto.gmss.GMSSRootSig;
import com.donjin.org.bouncycastle.pqc.crypto.gmss.Treehash;
import com.donjin.org.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.donjin.org.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSignature;
import com.donjin.org.bouncycastle.util.Arrays;
import java.util.Vector;

public class GMSSPrivateKeyParameters
extends GMSSKeyParameters {
    private int[] index;
    private byte[][] currentSeeds;
    private byte[][] nextNextSeeds;
    private byte[][][] currentAuthPaths;
    private byte[][][] nextAuthPaths;
    private Treehash[][] currentTreehash;
    private Treehash[][] nextTreehash;
    private Vector[] currentStack;
    private Vector[] nextStack;
    private Vector[][] currentRetain;
    private Vector[][] nextRetain;
    private byte[][][] keep;
    private GMSSLeaf[] nextNextLeaf;
    private GMSSLeaf[] upperLeaf;
    private GMSSLeaf[] upperTreehashLeaf;
    private int[] minTreehash;
    private GMSSParameters gmssPS;
    private byte[][] nextRoot;
    private GMSSRootCalc[] nextNextRoot;
    private byte[][] currentRootSig;
    private GMSSRootSig[] nextRootSig;
    private GMSSDigestProvider digestProvider;
    private boolean used = false;
    private int[] heightOfTrees;
    private int[] otsIndex;
    private int[] K;
    private int numLayer;
    private Digest messDigestTrees;
    private int mdLength;
    private GMSSRandom gmssRandom;
    private int[] numLeafs;

    public GMSSPrivateKeyParameters(byte[][] currentSeed, byte[][] nextNextSeed, byte[][][] currentAuthPath, byte[][][] nextAuthPath, Treehash[][] currentTreehash, Treehash[][] nextTreehash, Vector[] currentStack, Vector[] nextStack, Vector[][] currentRetain, Vector[][] nextRetain, byte[][] nextRoot, byte[][] currentRootSig, GMSSParameters gmssParameterset, GMSSDigestProvider digestProvider) {
        this(null, currentSeed, nextNextSeed, currentAuthPath, nextAuthPath, null, currentTreehash, nextTreehash, currentStack, nextStack, currentRetain, nextRetain, null, null, null, null, nextRoot, null, currentRootSig, null, gmssParameterset, digestProvider);
    }

    public GMSSPrivateKeyParameters(int[] index, byte[][] currentSeeds, byte[][] nextNextSeeds, byte[][][] currentAuthPaths, byte[][][] nextAuthPaths, byte[][][] keep, Treehash[][] currentTreehash, Treehash[][] nextTreehash, Vector[] currentStack, Vector[] nextStack, Vector[][] currentRetain, Vector[][] nextRetain, GMSSLeaf[] nextNextLeaf, GMSSLeaf[] upperLeaf, GMSSLeaf[] upperTreehashLeaf, int[] minTreehash, byte[][] nextRoot, GMSSRootCalc[] nextNextRoot, byte[][] currentRootSig, GMSSRootSig[] nextRootSig, GMSSParameters gmssParameterset, GMSSDigestProvider digestProvider) {
        super(true, gmssParameterset);
        int i;
        this.messDigestTrees = digestProvider.get();
        this.mdLength = this.messDigestTrees.getDigestSize();
        this.gmssPS = gmssParameterset;
        this.otsIndex = gmssParameterset.getWinternitzParameter();
        this.K = gmssParameterset.getK();
        this.heightOfTrees = gmssParameterset.getHeightOfTrees();
        this.numLayer = this.gmssPS.getNumOfLayers();
        if (index == null) {
            this.index = new int[this.numLayer];
            i = 0;
            while (i < this.numLayer) {
                this.index[i] = 0;
                ++i;
            }
        } else {
            this.index = index;
        }
        this.currentSeeds = currentSeeds;
        this.nextNextSeeds = nextNextSeeds;
        this.currentAuthPaths = currentAuthPaths;
        this.nextAuthPaths = nextAuthPaths;
        if (keep == null) {
            this.keep = new byte[this.numLayer][][];
            i = 0;
            while (i < this.numLayer) {
                this.keep[i] = new byte[(int)Math.floor(this.heightOfTrees[i] / 2)][this.mdLength];
                ++i;
            }
        } else {
            this.keep = keep;
        }
        if (currentStack == null) {
            this.currentStack = new Vector[this.numLayer];
            i = 0;
            while (i < this.numLayer) {
                this.currentStack[i] = new Vector();
                ++i;
            }
        } else {
            this.currentStack = currentStack;
        }
        if (nextStack == null) {
            this.nextStack = new Vector[this.numLayer - 1];
            i = 0;
            while (i < this.numLayer - 1) {
                this.nextStack[i] = new Vector();
                ++i;
            }
        } else {
            this.nextStack = nextStack;
        }
        this.currentTreehash = currentTreehash;
        this.nextTreehash = nextTreehash;
        this.currentRetain = currentRetain;
        this.nextRetain = nextRetain;
        this.nextRoot = nextRoot;
        this.digestProvider = digestProvider;
        if (nextNextRoot == null) {
            this.nextNextRoot = new GMSSRootCalc[this.numLayer - 1];
            i = 0;
            while (i < this.numLayer - 1) {
                this.nextNextRoot[i] = new GMSSRootCalc(this.heightOfTrees[i + 1], this.K[i + 1], this.digestProvider);
                ++i;
            }
        } else {
            this.nextNextRoot = nextNextRoot;
        }
        this.currentRootSig = currentRootSig;
        this.numLeafs = new int[this.numLayer];
        i = 0;
        while (i < this.numLayer) {
            this.numLeafs[i] = 1 << this.heightOfTrees[i];
            ++i;
        }
        this.gmssRandom = new GMSSRandom(this.messDigestTrees);
        if (this.numLayer > 1) {
            if (nextNextLeaf == null) {
                this.nextNextLeaf = new GMSSLeaf[this.numLayer - 2];
                i = 0;
                while (i < this.numLayer - 2) {
                    this.nextNextLeaf[i] = new GMSSLeaf(digestProvider.get(), this.otsIndex[i + 1], this.numLeafs[i + 2], this.nextNextSeeds[i]);
                    ++i;
                }
            } else {
                this.nextNextLeaf = nextNextLeaf;
            }
        } else {
            this.nextNextLeaf = new GMSSLeaf[0];
        }
        if (upperLeaf == null) {
            this.upperLeaf = new GMSSLeaf[this.numLayer - 1];
            i = 0;
            while (i < this.numLayer - 1) {
                this.upperLeaf[i] = new GMSSLeaf(digestProvider.get(), this.otsIndex[i], this.numLeafs[i + 1], this.currentSeeds[i]);
                ++i;
            }
        } else {
            this.upperLeaf = upperLeaf;
        }
        if (upperTreehashLeaf == null) {
            this.upperTreehashLeaf = new GMSSLeaf[this.numLayer - 1];
            i = 0;
            while (i < this.numLayer - 1) {
                this.upperTreehashLeaf[i] = new GMSSLeaf(digestProvider.get(), this.otsIndex[i], this.numLeafs[i + 1]);
                ++i;
            }
        } else {
            this.upperTreehashLeaf = upperTreehashLeaf;
        }
        if (minTreehash == null) {
            this.minTreehash = new int[this.numLayer - 1];
            i = 0;
            while (i < this.numLayer - 1) {
                this.minTreehash[i] = -1;
                ++i;
            }
        } else {
            this.minTreehash = minTreehash;
        }
        byte[] dummy = new byte[this.mdLength];
        byte[] OTSseed = new byte[this.mdLength];
        if (nextRootSig == null) {
            this.nextRootSig = new GMSSRootSig[this.numLayer - 1];
            int i2 = 0;
            while (i2 < this.numLayer - 1) {
                System.arraycopy(currentSeeds[i2], 0, dummy, 0, this.mdLength);
                this.gmssRandom.nextSeed(dummy);
                OTSseed = this.gmssRandom.nextSeed(dummy);
                this.nextRootSig[i2] = new GMSSRootSig(digestProvider.get(), this.otsIndex[i2], this.heightOfTrees[i2 + 1]);
                this.nextRootSig[i2].initSign(OTSseed, nextRoot[i2]);
                ++i2;
            }
        } else {
            this.nextRootSig = nextRootSig;
        }
    }

    private GMSSPrivateKeyParameters(GMSSPrivateKeyParameters original) {
        super(true, original.getParameters());
        this.index = Arrays.clone(original.index);
        this.currentSeeds = Arrays.clone(original.currentSeeds);
        this.nextNextSeeds = Arrays.clone(original.nextNextSeeds);
        this.currentAuthPaths = Arrays.clone(original.currentAuthPaths);
        this.nextAuthPaths = Arrays.clone(original.nextAuthPaths);
        this.currentTreehash = original.currentTreehash;
        this.nextTreehash = original.nextTreehash;
        this.currentStack = original.currentStack;
        this.nextStack = original.nextStack;
        this.currentRetain = original.currentRetain;
        this.nextRetain = original.nextRetain;
        this.keep = Arrays.clone(original.keep);
        this.nextNextLeaf = original.nextNextLeaf;
        this.upperLeaf = original.upperLeaf;
        this.upperTreehashLeaf = original.upperTreehashLeaf;
        this.minTreehash = original.minTreehash;
        this.gmssPS = original.gmssPS;
        this.nextRoot = Arrays.clone(original.nextRoot);
        this.nextNextRoot = original.nextNextRoot;
        this.currentRootSig = original.currentRootSig;
        this.nextRootSig = original.nextRootSig;
        this.digestProvider = original.digestProvider;
        this.heightOfTrees = original.heightOfTrees;
        this.otsIndex = original.otsIndex;
        this.K = original.K;
        this.numLayer = original.numLayer;
        this.messDigestTrees = original.messDigestTrees;
        this.mdLength = original.mdLength;
        this.gmssRandom = original.gmssRandom;
        this.numLeafs = original.numLeafs;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void markUsed() {
        this.used = true;
    }

    public GMSSPrivateKeyParameters nextKey() {
        GMSSPrivateKeyParameters nKey = new GMSSPrivateKeyParameters(this);
        nKey.nextKey(this.gmssPS.getNumOfLayers() - 1);
        return nKey;
    }

    private void nextKey(int layer) {
        if (layer == this.numLayer - 1) {
            int n = layer;
            this.index[n] = this.index[n] + 1;
        }
        if (this.index[layer] == this.numLeafs[layer]) {
            if (this.numLayer != 1) {
                this.nextTree(layer);
                this.index[layer] = 0;
            }
        } else {
            this.updateKey(layer);
        }
    }

    private void nextTree(int layer) {
        if (layer > 0) {
            int n = layer - 1;
            this.index[n] = this.index[n] + 1;
            boolean lastTree = true;
            int z = layer;
            do {
                if (this.index[--z] >= this.numLeafs[z]) continue;
                lastTree = false;
            } while (lastTree && z > 0);
            if (!lastTree) {
                this.gmssRandom.nextSeed(this.currentSeeds[layer]);
                this.nextRootSig[layer - 1].updateSign();
                if (layer > 1) {
                    this.nextNextLeaf[layer - 1 - 1] = this.nextNextLeaf[layer - 1 - 1].nextLeaf();
                }
                this.upperLeaf[layer - 1] = this.upperLeaf[layer - 1].nextLeaf();
                if (this.minTreehash[layer - 1] >= 0) {
                    this.upperTreehashLeaf[layer - 1] = this.upperTreehashLeaf[layer - 1].nextLeaf();
                    byte[] leaf = this.upperTreehashLeaf[layer - 1].getLeaf();
                    try {
                        this.currentTreehash[layer - 1][this.minTreehash[layer - 1]].update(this.gmssRandom, leaf);
                        this.currentTreehash[layer - 1][this.minTreehash[layer - 1]].wasFinished();
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                }
                this.updateNextNextAuthRoot(layer);
                this.currentRootSig[layer - 1] = this.nextRootSig[layer - 1].getSig();
                int i = 0;
                while (i < this.heightOfTrees[layer] - this.K[layer]) {
                    this.currentTreehash[layer][i] = this.nextTreehash[layer - 1][i];
                    this.nextTreehash[layer - 1][i] = this.nextNextRoot[layer - 1].getTreehash()[i];
                    ++i;
                }
                i = 0;
                while (i < this.heightOfTrees[layer]) {
                    System.arraycopy(this.nextAuthPaths[layer - 1][i], 0, this.currentAuthPaths[layer][i], 0, this.mdLength);
                    System.arraycopy(this.nextNextRoot[layer - 1].getAuthPath()[i], 0, this.nextAuthPaths[layer - 1][i], 0, this.mdLength);
                    ++i;
                }
                i = 0;
                while (i < this.K[layer] - 1) {
                    this.currentRetain[layer][i] = this.nextRetain[layer - 1][i];
                    this.nextRetain[layer - 1][i] = this.nextNextRoot[layer - 1].getRetain()[i];
                    ++i;
                }
                this.currentStack[layer] = this.nextStack[layer - 1];
                this.nextStack[layer - 1] = this.nextNextRoot[layer - 1].getStack();
                this.nextRoot[layer - 1] = this.nextNextRoot[layer - 1].getRoot();
                byte[] OTSseed = new byte[this.mdLength];
                byte[] dummy = new byte[this.mdLength];
                System.arraycopy(this.currentSeeds[layer - 1], 0, dummy, 0, this.mdLength);
                OTSseed = this.gmssRandom.nextSeed(dummy);
                OTSseed = this.gmssRandom.nextSeed(dummy);
                OTSseed = this.gmssRandom.nextSeed(dummy);
                this.nextRootSig[layer - 1].initSign(OTSseed, this.nextRoot[layer - 1]);
                this.nextKey(layer - 1);
            }
        }
    }

    private void updateKey(int layer) {
        this.computeAuthPaths(layer);
        if (layer > 0) {
            if (layer > 1) {
                this.nextNextLeaf[layer - 1 - 1] = this.nextNextLeaf[layer - 1 - 1].nextLeaf();
            }
            this.upperLeaf[layer - 1] = this.upperLeaf[layer - 1].nextLeaf();
            int t = (int)Math.floor((double)(this.getNumLeafs(layer) * 2) / (double)(this.heightOfTrees[layer - 1] - this.K[layer - 1]));
            if (this.index[layer] % t == 1) {
                if (this.index[layer] > 1 && this.minTreehash[layer - 1] >= 0) {
                    byte[] leaf = this.upperTreehashLeaf[layer - 1].getLeaf();
                    try {
                        this.currentTreehash[layer - 1][this.minTreehash[layer - 1]].update(this.gmssRandom, leaf);
                        this.currentTreehash[layer - 1][this.minTreehash[layer - 1]].wasFinished();
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                }
                this.minTreehash[layer - 1] = this.getMinTreehashIndex(layer - 1);
                if (this.minTreehash[layer - 1] >= 0) {
                    byte[] seed = this.currentTreehash[layer - 1][this.minTreehash[layer - 1]].getSeedActive();
                    this.upperTreehashLeaf[layer - 1] = new GMSSLeaf(this.digestProvider.get(), this.otsIndex[layer - 1], t, seed);
                    this.upperTreehashLeaf[layer - 1] = this.upperTreehashLeaf[layer - 1].nextLeaf();
                }
            } else if (this.minTreehash[layer - 1] >= 0) {
                this.upperTreehashLeaf[layer - 1] = this.upperTreehashLeaf[layer - 1].nextLeaf();
            }
            this.nextRootSig[layer - 1].updateSign();
            if (this.index[layer] == 1) {
                this.nextNextRoot[layer - 1].initialize(new Vector());
            }
            this.updateNextNextAuthRoot(layer);
        }
    }

    private int getMinTreehashIndex(int layer) {
        int minTreehash = -1;
        int h = 0;
        while (h < this.heightOfTrees[layer] - this.K[layer]) {
            if (this.currentTreehash[layer][h].wasInitialized() && !this.currentTreehash[layer][h].wasFinished()) {
                if (minTreehash == -1) {
                    minTreehash = h;
                } else if (this.currentTreehash[layer][h].getLowestNodeHeight() < this.currentTreehash[layer][minTreehash].getLowestNodeHeight()) {
                    minTreehash = h;
                }
            }
            ++h;
        }
        return minTreehash;
    }

    private void computeAuthPaths(int layer) {
        int Phi = this.index[layer];
        int H = this.heightOfTrees[layer];
        int K = this.K[layer];
        int i = 0;
        while (i < H - K) {
            this.currentTreehash[layer][i].updateNextSeed(this.gmssRandom);
            ++i;
        }
        int Tau = this.heightOfPhi(Phi);
        byte[] OTSseed = new byte[this.mdLength];
        OTSseed = this.gmssRandom.nextSeed(this.currentSeeds[layer]);
        int L = Phi >>> Tau + 1 & 1;
        byte[] tempKeep = new byte[this.mdLength];
        if (Tau < H - 1 && L == 0) {
            System.arraycopy(this.currentAuthPaths[layer][Tau], 0, tempKeep, 0, this.mdLength);
        }
        byte[] help = new byte[this.mdLength];
        if (Tau == 0) {
            if (layer == this.numLayer - 1) {
                WinternitzOTSignature ots = new WinternitzOTSignature(OTSseed, this.digestProvider.get(), this.otsIndex[layer]);
                help = ots.getPublicKey();
            } else {
                byte[] dummy = new byte[this.mdLength];
                System.arraycopy(this.currentSeeds[layer], 0, dummy, 0, this.mdLength);
                this.gmssRandom.nextSeed(dummy);
                help = this.upperLeaf[layer].getLeaf();
                this.upperLeaf[layer].initLeafCalc(dummy);
            }
            System.arraycopy(help, 0, this.currentAuthPaths[layer][0], 0, this.mdLength);
        } else {
            byte[] toBeHashed = new byte[this.mdLength << 1];
            System.arraycopy(this.currentAuthPaths[layer][Tau - 1], 0, toBeHashed, 0, this.mdLength);
            System.arraycopy(this.keep[layer][(int)Math.floor((Tau - 1) / 2)], 0, toBeHashed, this.mdLength, this.mdLength);
            this.messDigestTrees.update(toBeHashed, 0, toBeHashed.length);
            this.currentAuthPaths[layer][Tau] = new byte[this.messDigestTrees.getDigestSize()];
            this.messDigestTrees.doFinal(this.currentAuthPaths[layer][Tau], 0);
            int i2 = 0;
            while (i2 < Tau) {
                int startPoint;
                if (i2 < H - K) {
                    if (this.currentTreehash[layer][i2].wasFinished()) {
                        System.arraycopy(this.currentTreehash[layer][i2].getFirstNode(), 0, this.currentAuthPaths[layer][i2], 0, this.mdLength);
                        this.currentTreehash[layer][i2].destroy();
                    } else {
                        System.err.println("Treehash (" + layer + "," + i2 + ") not finished when needed in AuthPathComputation");
                    }
                }
                if (i2 < H - 1 && i2 >= H - K && this.currentRetain[layer][i2 - (H - K)].size() > 0) {
                    System.arraycopy(this.currentRetain[layer][i2 - (H - K)].lastElement(), 0, this.currentAuthPaths[layer][i2], 0, this.mdLength);
                    this.currentRetain[layer][i2 - (H - K)].removeElementAt(this.currentRetain[layer][i2 - (H - K)].size() - 1);
                }
                if (i2 < H - K && (startPoint = Phi + 3 * (1 << i2)) < this.numLeafs[layer]) {
                    this.currentTreehash[layer][i2].initialize();
                }
                ++i2;
            }
        }
        if (Tau < H - 1 && L == 0) {
            System.arraycopy(tempKeep, 0, this.keep[layer][(int)Math.floor(Tau / 2)], 0, this.mdLength);
        }
        if (layer == this.numLayer - 1) {
            int tmp = 1;
            while (tmp <= (H - K) / 2) {
                int minTreehash = this.getMinTreehashIndex(layer);
                if (minTreehash >= 0) {
                    try {
                        byte[] seed = new byte[this.mdLength];
                        System.arraycopy(this.currentTreehash[layer][minTreehash].getSeedActive(), 0, seed, 0, this.mdLength);
                        byte[] seed2 = this.gmssRandom.nextSeed(seed);
                        WinternitzOTSignature ots = new WinternitzOTSignature(seed2, this.digestProvider.get(), this.otsIndex[layer]);
                        byte[] leaf = ots.getPublicKey();
                        this.currentTreehash[layer][minTreehash].update(this.gmssRandom, leaf);
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                }
                ++tmp;
            }
        } else {
            this.minTreehash[layer] = this.getMinTreehashIndex(layer);
        }
    }

    private int heightOfPhi(int Phi) {
        if (Phi == 0) {
            return -1;
        }
        int Tau = 0;
        int modul = 1;
        while (Phi % modul == 0) {
            modul *= 2;
            ++Tau;
        }
        return Tau - 1;
    }

    private void updateNextNextAuthRoot(int layer) {
        byte[] OTSseed = new byte[this.mdLength];
        OTSseed = this.gmssRandom.nextSeed(this.nextNextSeeds[layer - 1]);
        if (layer == this.numLayer - 1) {
            WinternitzOTSignature ots = new WinternitzOTSignature(OTSseed, this.digestProvider.get(), this.otsIndex[layer]);
            this.nextNextRoot[layer - 1].update(this.nextNextSeeds[layer - 1], ots.getPublicKey());
        } else {
            this.nextNextRoot[layer - 1].update(this.nextNextSeeds[layer - 1], this.nextNextLeaf[layer - 1].getLeaf());
            this.nextNextLeaf[layer - 1].initLeafCalc(this.nextNextSeeds[layer - 1]);
        }
    }

    public int[] getIndex() {
        return this.index;
    }

    public int getIndex(int i) {
        return this.index[i];
    }

    public byte[][] getCurrentSeeds() {
        return Arrays.clone(this.currentSeeds);
    }

    public byte[][][] getCurrentAuthPaths() {
        return Arrays.clone(this.currentAuthPaths);
    }

    public byte[] getSubtreeRootSig(int i) {
        return this.currentRootSig[i];
    }

    public GMSSDigestProvider getName() {
        return this.digestProvider;
    }

    public int getNumLeafs(int i) {
        return this.numLeafs[i];
    }
}

