/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pqc.asn1;

import com.donjin.org.bouncycastle.asn1.ASN1EncodableVector;
import com.donjin.org.bouncycastle.asn1.ASN1Integer;
import com.donjin.org.bouncycastle.asn1.ASN1Object;
import com.donjin.org.bouncycastle.asn1.ASN1Primitive;
import com.donjin.org.bouncycastle.asn1.ASN1Sequence;
import com.donjin.org.bouncycastle.asn1.DEROctetString;
import com.donjin.org.bouncycastle.asn1.DERSequence;
import com.donjin.org.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class XMSSPublicKey
extends ASN1Object {
    private final byte[] publicSeed;
    private final byte[] root;

    public XMSSPublicKey(byte[] publicSeed, byte[] root) {
        this.publicSeed = Arrays.clone(publicSeed);
        this.root = Arrays.clone(root);
    }

    private XMSSPublicKey(ASN1Sequence seq) {
        if (!ASN1Integer.getInstance(seq.getObjectAt(0)).getValue().equals(BigInteger.valueOf(0L))) {
            throw new IllegalArgumentException("unknown version of sequence");
        }
        this.publicSeed = Arrays.clone(DEROctetString.getInstance(seq.getObjectAt(1)).getOctets());
        this.root = Arrays.clone(DEROctetString.getInstance(seq.getObjectAt(2)).getOctets());
    }

    public static XMSSPublicKey getInstance(Object o) {
        if (o instanceof XMSSPublicKey) {
            return (XMSSPublicKey)o;
        }
        if (o != null) {
            return new XMSSPublicKey(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public byte[] getPublicSeed() {
        return Arrays.clone(this.publicSeed);
    }

    public byte[] getRoot() {
        return Arrays.clone(this.root);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(0L));
        v.add(new DEROctetString(this.publicSeed));
        v.add(new DEROctetString(this.root));
        return new DERSequence(v);
    }
}

