/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.pkcs;

import com.donjin.org.bouncycastle.asn1.ASN1OctetString;
import com.donjin.org.bouncycastle.asn1.ASN1Sequence;
import com.donjin.org.bouncycastle.asn1.pkcs.ContentInfo;
import com.donjin.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.donjin.org.bouncycastle.asn1.pkcs.SafeBag;
import com.donjin.org.bouncycastle.cms.CMSEncryptedData;
import com.donjin.org.bouncycastle.cms.CMSException;
import com.donjin.org.bouncycastle.operator.InputDecryptorProvider;
import com.donjin.org.bouncycastle.pkcs.PKCS12SafeBag;
import com.donjin.org.bouncycastle.pkcs.PKCSException;

public class PKCS12SafeBagFactory {
    private ASN1Sequence safeBagSeq;

    public PKCS12SafeBagFactory(ContentInfo info) {
        if (info.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            throw new IllegalArgumentException("encryptedData requires constructor with decryptor.");
        }
        this.safeBagSeq = ASN1Sequence.getInstance(ASN1OctetString.getInstance(info.getContent()).getOctets());
    }

    public PKCS12SafeBagFactory(ContentInfo info, InputDecryptorProvider inputDecryptorProvider) throws PKCSException {
        if (info.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            CMSEncryptedData encData = new CMSEncryptedData(com.donjin.org.bouncycastle.asn1.cms.ContentInfo.getInstance(info));
            try {
                this.safeBagSeq = ASN1Sequence.getInstance(encData.getContent(inputDecryptorProvider));
            }
            catch (CMSException e) {
                throw new PKCSException("unable to extract data: " + e.getMessage(), e);
            }
            return;
        }
        throw new IllegalArgumentException("encryptedData requires constructor with decryptor.");
    }

    public PKCS12SafeBag[] getSafeBags() {
        PKCS12SafeBag[] safeBags = new PKCS12SafeBag[this.safeBagSeq.size()];
        int i = 0;
        while (i != this.safeBagSeq.size()) {
            safeBags[i] = new PKCS12SafeBag(SafeBag.getInstance(this.safeBagSeq.getObjectAt(i)));
            ++i;
        }
        return safeBags;
    }
}

