/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.operator.jcajce;

import com.donjin.org.bouncycastle.asn1.ASN1Encodable;
import com.donjin.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.donjin.org.bouncycastle.asn1.ASN1OctetString;
import com.donjin.org.bouncycastle.asn1.cryptopro.GOST28147Parameters;
import com.donjin.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.donjin.org.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import com.donjin.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.donjin.org.bouncycastle.jcajce.util.JcaJceHelper;
import com.donjin.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.donjin.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.donjin.org.bouncycastle.operator.InputDecryptor;
import com.donjin.org.bouncycastle.operator.InputDecryptorProvider;
import com.donjin.org.bouncycastle.operator.OperatorCreationException;
import com.donjin.org.bouncycastle.util.Arrays;
import java.io.InputStream;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class JceInputDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JceInputDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JceInputDecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public InputDecryptorProvider build(byte[] keyBytes) {
        final byte[] encKeyBytes = Arrays.clone(keyBytes);
        return new InputDecryptorProvider(){
            private Cipher cipher;
            private AlgorithmIdentifier encryptionAlg;

            @Override
            public InputDecryptor get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                this.encryptionAlg = algorithmIdentifier;
                ASN1ObjectIdentifier algorithm = algorithmIdentifier.getAlgorithm();
                try {
                    this.cipher = JceInputDecryptorProviderBuilder.this.helper.createCipher(algorithm.getId());
                    SecretKeySpec key = new SecretKeySpec(encKeyBytes, algorithm.getId());
                    ASN1Encodable encParams = algorithmIdentifier.getParameters();
                    if (encParams instanceof ASN1OctetString) {
                        this.cipher.init(2, (Key)key, new IvParameterSpec(ASN1OctetString.getInstance(encParams).getOctets()));
                    } else {
                        GOST28147Parameters gParams = GOST28147Parameters.getInstance(encParams);
                        this.cipher.init(2, (Key)key, new GOST28147ParameterSpec(gParams.getEncryptionParamSet(), gParams.getIV()));
                    }
                }
                catch (Exception e) {
                    throw new OperatorCreationException("unable to create InputDecryptor: " + e.getMessage(), e);
                }
                return new InputDecryptor(){

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return encryptionAlg;
                    }

                    @Override
                    public InputStream getInputStream(InputStream input) {
                        return new CipherInputStream(input, cipher);
                    }
                };
            }
        };
    }
}

